/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.token;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.XMLTokenType;
import org.pageseeder.xmlwriter.XMLWriter;

public interface AttributeToken
extends XMLToken {
    @Override
    @NotNull
    public String getName();

    @Override
    @NotNull
    public String getValue();

    @Override
    @NotNull
    public String getNamespaceURI();

    @Override
    @NotNull
    default public XMLTokenType getType() {
        return XMLTokenType.ATTRIBUTE;
    }

    @Override
    default public boolean equals(XMLToken token) {
        if (token == this) {
            return true;
        }
        if (!(token instanceof AttributeToken)) {
            return false;
        }
        AttributeToken other = (AttributeToken)token;
        return this.getNamespaceURI().equals(other.getNamespaceURI()) && this.getName().equals(other.getName()) && this.getValue().equals(other.getValue());
    }

    default public void toXML(XMLWriter xml) throws IOException {
        xml.attribute(this.getNamespaceURI(), this.getName(), this.getValue());
    }

    @Override
    default public void toXML(@NotNull XMLStreamWriter xml) throws XMLStreamException {
        if (this.getNamespaceURI().isEmpty()) {
            xml.writeAttribute(this.getName(), this.getValue());
        } else {
            xml.writeAttribute(this.getNamespaceURI(), this.getName(), this.getValue());
        }
    }
}

