/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.format;

import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.format.XMLDiffOutput;
import org.pageseeder.diffx.format.XMLDiffOutputBase;
import org.pageseeder.diffx.token.AttributeToken;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.TextToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.XMLTokenType;
import org.pageseeder.diffx.xml.Namespace;

public final class StrictXMLDiffOutput
extends XMLDiffOutputBase
implements XMLDiffOutput {
    private static final String DEL_TAG = "del";
    private static final String INS_TAG = "ins";
    private final XMLStreamWriter xml;
    private boolean declareNamespace = true;
    private Operator lastOperatorTag = Operator.MATCH;

    public StrictXMLDiffOutput() {
        this(System.out);
    }

    public StrictXMLDiffOutput(Writer w) {
        XMLOutputFactory output = XMLOutputFactory.newInstance();
        output.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        try {
            this.xml = output.createXMLStreamWriter(w);
        }
        catch (XMLStreamException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public StrictXMLDiffOutput(OutputStream out) {
        XMLOutputFactory output = XMLOutputFactory.newInstance();
        output.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        try {
            this.xml = output.createXMLStreamWriter(out);
        }
        catch (XMLStreamException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void start() {
        try {
            if (this.includeXMLDeclaration) {
                this.xml.writeStartDocument("utf-8", "1.0");
            }
            this.xml.setDefaultNamespace(null);
            for (Namespace namespace : this.namespaces) {
                String uri = namespace.getUri();
                if (uri.isEmpty()) continue;
                this.xml.setPrefix(namespace.getPrefix(), uri);
            }
        }
        catch (XMLStreamException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void handle(@NotNull Operator operator, XMLToken token) throws UncheckedIOException, IllegalStateException {
        try {
            if (token.getType() != XMLTokenType.ATTRIBUTE && this.lastOperatorTag.isEdit() && this.lastOperatorTag != operator) {
                this.xml.writeEndElement();
                this.lastOperatorTag = Operator.MATCH;
            }
            if (token instanceof StartElementToken) {
                token.toXML(this.xml);
                if (this.declareNamespace) {
                    this.xml.writeNamespace(this.getDiffNamespace().getPrefix(), this.getDiffNamespace().getUri());
                    this.declareNamespace = false;
                }
                if (operator == Operator.INS) {
                    this.xml.writeAttribute(this.getDiffNamespace().getUri(), "insert", "true");
                }
                if (operator == Operator.DEL) {
                    this.xml.writeAttribute(this.getDiffNamespace().getUri(), "delete", "true");
                }
            } else if (token instanceof EndElementToken) {
                token.toXML(this.xml);
            } else if (token instanceof AttributeToken) {
                if (operator != Operator.DEL) {
                    token.toXML(this.xml);
                }
            } else if (token instanceof TextToken) {
                if (operator.isEdit() && this.lastOperatorTag != operator) {
                    this.xml.writeStartElement(operator == Operator.INS ? INS_TAG : DEL_TAG);
                    this.lastOperatorTag = operator;
                }
                token.toXML(this.xml);
            } else {
                token.toXML(this.xml);
            }
            this.xml.flush();
        }
        catch (XMLStreamException ex) {
            ex.printStackTrace();
        }
    }
}

