/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.algorithm;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.algorithm.EdgeSnake;
import org.pageseeder.diffx.algorithm.MyersAlgorithm;
import org.pageseeder.diffx.algorithm.Point;
import org.pageseeder.diffx.algorithm.Vector;
import org.pageseeder.diffx.algorithm.XMLStackMap;
import org.pageseeder.diffx.api.DiffAlgorithm;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.handler.PostXMLFixer;
import org.pageseeder.diffx.token.XMLToken;

public final class MyersGreedyXMLAlgorithm
extends MyersAlgorithm<XMLToken>
implements DiffAlgorithm<XMLToken> {
    private static final boolean DEBUG = false;

    @Override
    public void diff(@NotNull List<? extends XMLToken> from, @NotNull List<? extends XMLToken> to, @NotNull DiffHandler<XMLToken> handler) {
        Instance instance = new Instance(from, to);
        List<EdgeSnake> snakes = instance.computePath();
        PostXMLFixer correction = new PostXMLFixer(handler);
        correction.start();
        this.handleResults(from, to, correction, snakes);
        correction.end();
    }

    private static EdgeSnake createToPoint(Point point, Vector vector, int k, int d) {
        int aEnd = point.x();
        int bEnd = point.y();
        boolean down = k == -d || k != d && vector.getX(k - 1) < vector.getX(k + 1);
        int xStart = down ? vector.getX(k + 1) : vector.getX(k - 1);
        int yStart = xStart - (down ? k + 1 : k - 1);
        int xEnd = down ? xStart : xStart + 1;
        int yEnd = xEnd - k;
        int matching = Math.min(aEnd - xEnd, bEnd - yEnd);
        EdgeSnake.Direction direction = down ? EdgeSnake.Direction.DOWN : EdgeSnake.Direction.RIGHT;
        return EdgeSnake.create(0, aEnd, 0, bEnd, direction, xStart, yStart, 1, matching);
    }

    public String toString() {
        return "MyersGreedyXMLAlgorithm";
    }

    private static class Instance {
        private final List<? extends XMLToken> a;
        private final List<? extends XMLToken> b;
        private final int sizeA;
        private final int sizeB;

        Instance(List<? extends XMLToken> a, List<? extends XMLToken> b) {
            this.a = a;
            this.b = b;
            this.sizeA = a.size();
            this.sizeB = b.size();
        }

        private List<EdgeSnake> computePath() {
            Vector vector = Vector.createGreedy(this.sizeA, this.sizeB);
            ArrayList<Vector> vectors = new ArrayList<Vector>();
            XMLStackMap elements = new XMLStackMap();
            int max = this.sizeA + this.sizeB;
            boolean found = false;
            for (int d = 0; d <= max; ++d) {
                found = this.forward(vector, elements, d);
                vectors.add(vector.snapshot(d));
                if (found) break;
            }
            if (!found) {
                throw new IllegalStateException("Unable to find a solution!");
            }
            return this.solve(vectors);
        }

        private boolean forward(Vector vector, XMLStackMap elements, int d) {
            elements.nextDiff();
            for (int k = -d; k <= d; k += 2) {
                int xLeft = k != -d ? vector.getX(k - 1) : 0;
                int xUp = k != d ? vector.getX(k + 1) : 0;
                boolean down = k == -d || k != d && xLeft < xUp;
                elements.initK(k, down);
                int x = down ? xUp : xLeft + 1;
                int y = x - k;
                XMLToken editToken = this.getEditToken(down, x, y);
                if (editToken == null || elements.isAllowed(k, down ? Operator.INS : Operator.DEL, editToken)) {
                    if (editToken != null) {
                        Operator op = down ? Operator.INS : Operator.DEL;
                        elements.update(k, op, editToken);
                    }
                    while (x < this.sizeA && y < this.sizeB && this.a.get(x).equals(this.b.get(y)) && elements.isAllowed(k, Operator.MATCH, this.a.get(x))) {
                        elements.update(k, Operator.MATCH, this.a.get(x));
                        ++x;
                        ++y;
                    }
                } else {
                    x = down ? x : x - 1;
                    y = down ? y - 1 : y;
                }
                vector.setX(k, x);
                if (x < this.sizeA || y < this.sizeB) continue;
                return true;
            }
            return false;
        }

        private XMLToken getEditToken(boolean down, int x, int y) {
            boolean hasEdit;
            boolean bl = down ? y > 0 && y <= this.sizeB : (hasEdit = x > 0 && x <= this.sizeA);
            if (!hasEdit) {
                return null;
            }
            return down ? this.b.get(y - 1) : this.a.get(x - 1);
        }

        private List<EdgeSnake> solve(List<Vector> vectors) {
            ArrayList<EdgeSnake> snakes = new ArrayList<EdgeSnake>();
            Point p = new Point(this.sizeA, this.sizeB);
            int d = vectors.size() - 1;
            while (p.x() > 0 || p.y() > 0) {
                int yEnd;
                int k;
                Vector vector = vectors.get(d);
                int xEnd = vector.getX(k = p.x() - p.y());
                if (p.isNotSame(xEnd, yEnd = xEnd - k)) {
                    throw new IllegalStateException("No solution for d:" + d + " k:" + k + " p:" + String.valueOf(p) + " V:( " + xEnd + ", " + yEnd + " )");
                }
                EdgeSnake solution = MyersGreedyXMLAlgorithm.createToPoint(p, vector, k, d);
                if (p.isNotSame(solution.getXEnd(), solution.getYEnd())) {
                    throw new IllegalStateException("Missed solution for d:" + d + " k:" + k + " p:" + String.valueOf(p) + " V:( " + xEnd + ", " + yEnd + " )");
                }
                if (!snakes.isEmpty()) {
                    EdgeSnake snake = (EdgeSnake)snakes.get(0);
                    if (!snake.append(solution)) {
                        snakes.add(0, solution);
                    }
                } else {
                    snakes.add(0, solution);
                }
                p = solution.getStartPoint();
                --d;
            }
            return snakes;
        }
    }
}

