/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.template;

import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.pageseeder.psml.template.Token;
import org.pageseeder.psml.template.XML;

final class TError
implements Token {
    private final String message;
    private final boolean hasNonASCIIChar;

    public TError(String message) {
        this.message = Objects.requireNonNull(message);
        this.hasNonASCIIChar = XML.hasNonASCIIChar(message);
    }

    public String message() {
        return this.message;
    }

    @Override
    public void print(PrintWriter psml, Map<String, String> values, Charset charset) {
        if (this.hasNonASCIIChar && charset.equals(StandardCharsets.US_ASCII)) {
            XML.toASCII("<!-- Template error: " + this.message + " -->", psml);
        } else {
            psml.print("<!-- Template error: " + this.message + " -->");
        }
    }
}

