/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.split;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Templates;
import org.pageseeder.psml.util.XSLT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PSMLSplitter {
    private final Builder _builder;
    private final Logger _logger;

    private PSMLSplitter(Builder producer, Logger log) {
        if (producer.source() == null) {
            throw new NullPointerException("source is null");
        }
        if (producer.destination() == null) {
            throw new NullPointerException("destination is null");
        }
        if (producer.config() == null) {
            throw new NullPointerException("config is null");
        }
        this._builder = producer;
        this._logger = log;
    }

    public void process() throws IOException {
        File destination;
        File source = this._builder.source();
        String name = this._builder.destination().getName();
        if (name.endsWith(".psml")) {
            destination = this._builder.destination().getParentFile();
        } else {
            destination = this._builder.destination();
            name = source.getName();
        }
        if (!destination.exists()) {
            destination.mkdirs();
        }
        Templates pre1 = XSLT.getTemplatesFromResource("org/pageseeder/psml/split/pre-split1.xsl");
        Templates pre2 = XSLT.getTemplatesFromResource("org/pageseeder/psml/split/pre-split2.xsl");
        Templates split = XSLT.getTemplatesFromResource("org/pageseeder/psml/split/split.xsl");
        String outuri = destination.toURI().toString();
        this._logger.info("PSML Splitter: Moving media files");
        String mediaFolderName = this._builder.media() == null ? "images" : this._builder.media();
        File mediaFolder = new File(source.getParentFile(), mediaFolderName);
        if (mediaFolder.exists()) {
            Files.move(mediaFolder.toPath(), new File(destination, mediaFolderName).toPath(), new CopyOption[0]);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_outputfolder", outuri);
        parameters.put("_outputfilename", name);
        parameters.put("_mediafoldername", mediaFolderName);
        parameters.put("_configfileurl", this._builder.config().toURI().toString());
        parameters.putAll(this._builder.params());
        this._logger.info("PSML Splitter: First pre-process");
        File pre_split1 = new File(this._builder.working(), "pre-split1.xml");
        XSLT.transform(source, pre_split1, pre1, parameters);
        this._logger.info("PSML Splitter: Second pre-process");
        File pre_split2 = new File(this._builder.working(), "pre-split2.xml");
        XSLT.transform(pre_split1, pre_split2, pre2, parameters);
        this._logger.info("PSML Splitter: Splitting PSML");
        XSLT.transform(pre_split2, new File(destination, name), split, parameters);
    }

    public static class Builder {
        private File source;
        private File destination;
        private File working;
        private File config;
        private String media;
        private Map<String, String> params;
        private Logger logger;

        private File source() {
            return this.source;
        }

        private File destination() {
            if (this.destination == null) {
                this.destination = new File(this.source.getParentFile(), "output.psml");
            }
            return this.destination;
        }

        private File working() {
            if (this.working == null) {
                String tmp = "split-" + System.currentTimeMillis();
                this.working = new File(System.getProperty("java.io.tmpdir"), tmp);
            }
            if (!this.working.exists()) {
                this.working.mkdirs();
            }
            return this.working;
        }

        private File config() {
            if (this.config != null && this.config.exists()) {
                return this.config;
            }
            return null;
        }

        private String media() {
            return this.media;
        }

        private Map<String, String> params() {
            if (this.params == null) {
                this.params = new HashMap<String, String>();
            }
            return this.params;
        }

        public Builder log(Logger log) {
            this.logger = log;
            return this;
        }

        public Builder source(File source) {
            this.source = source;
            return this;
        }

        public Builder destination(File destination) {
            this.destination = destination;
            return this;
        }

        public Builder working(File working) {
            this.working = working;
            return this;
        }

        public Builder config(File config) {
            this.config = config;
            return this;
        }

        public Builder media(String media) {
            this.media = media;
            return this;
        }

        public Builder params(Map<String, String> params) {
            this.params = params;
            return this;
        }

        public PSMLSplitter build() {
            if (this.logger != null) {
                return new PSMLSplitter(this, this.logger);
            }
            return new PSMLSplitter(this, LoggerFactory.getLogger(PSMLSplitter.class));
        }
    }
}

