/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.process.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.process.ProcessException;
import org.pageseeder.psml.process.config.XSLTTransformation;
import org.pageseeder.psml.process.util.IncludesExcludesMatcher;
import org.pageseeder.psml.process.util.XMLUtils;
import org.slf4j.Logger;

public final class XSLTTransformer {
    private static final int BUFFER_SIZE = 12288;
    private final @Nullable XSLTTransformation transformationDetails;
    private @Nullable Logger logger = null;
    private boolean preserveSrc = false;
    private boolean failOnError = true;
    private boolean validate = true;
    private boolean moveAll = true;

    public XSLTTransformer(@Nullable XSLTTransformation xslt) {
        if (xslt != null && xslt.getXSLT() == null) {
            throw new IllegalArgumentException("XSLT script cannot be null");
        }
        this.transformationDetails = xslt;
    }

    public void setPreserveSrc(boolean preserve) {
        this.preserveSrc = preserve;
    }

    public void setFailOnError(boolean failonerror) {
        this.failOnError = failonerror;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void setMoveAll(boolean moveall) {
        this.moveAll = moveall;
    }

    public String getXSLT() {
        return this.transformationDetails == null ? "No Script" : this.transformationDetails.getXSLT();
    }

    public void setLog(Logger log) {
        this.logger = log;
    }

    public void transform(Map<String, File> psmlFiles, File destinationFolder) throws ProcessException {
        if (this.transformationDetails == null) {
            return;
        }
        File xslt = new File(this.transformationDetails.getXSLT());
        if (!xslt.exists() || !xslt.isFile()) {
            throw new ProcessException("Invalid XSLT script " + this.transformationDetails.getXSLT());
        }
        XSLTErrorListener listener = null;
        if (this.logger != null) {
            this.logger.debug("Transform: Loading XSLT script {}", (Object)xslt.getAbsolutePath());
            listener = new XSLTErrorListener(this.logger);
        }
        Transformer transformer = XMLUtils.createTransformer(xslt, listener);
        transformer.setErrorListener(listener);
        Map<String, String> params = this.transformationDetails.getParams();
        for (Map.Entry<String, String> p : params.entrySet()) {
            transformer.setParameter(p.getKey(), p.getValue());
        }
        URL schema = null;
        if (this.validate) {
            ClassLoader loader = XSLTTransformer.class.getClassLoader();
            schema = loader.getResource(XSLTTransformer.class.getPackage().getName().replace('.', '/') + "/psml-processed.xsd");
        }
        IncludesExcludesMatcher matcher = this.transformationDetails.buildMatcher();
        for (String relPath : psmlFiles.keySet()) {
            File output;
            boolean transform = matcher == null || !matcher.hasPatterns() || matcher.matches(relPath);
            try {
                output = new File(destinationFolder, relPath);
                output.getParentFile().mkdirs();
                if (transform && !output.exists() && !output.createNewFile()) {
                    throw new ProcessException("Failed to create output file " + output.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new ProcessException("XRefs error: Failed to create temp file: " + e.getMessage(), e);
            }
            if (transform) {
                if (this.logger != null) {
                    this.logger.debug("Transform: Transforming file {}", (Object)relPath);
                }
                try {
                    XMLUtils.transform(psmlFiles.get(relPath), output, transformer, schema, null, null);
                }
                catch (ProcessException ex) {
                    if (this.failOnError) {
                        throw ex;
                    }
                    if (this.logger == null) continue;
                    this.logger.error(ex.getMessage());
                }
                continue;
            }
            if (!this.moveAll) continue;
            this.moveFile(psmlFiles.get(relPath), output);
        }
        if (this.logger != null) {
            this.logger.debug("Transform: Complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveFile(File from, File to) throws ProcessException {
        block9: {
            to.getParentFile().mkdirs();
            if (this.preserveSrc) {
                try {
                    FileInputStream fis = new FileInputStream(from);
                    FileOutputStream fos = new FileOutputStream(to);
                    try {
                        int read;
                        byte[] buffer = new byte[12288];
                        while ((read = fis.read(buffer)) != -1) {
                            fos.write(buffer, 0, read);
                        }
                        break block9;
                    }
                    finally {
                        fis.close();
                        fos.close();
                    }
                }
                catch (IOException ex) {
                    throw new ProcessException("Failed to copy file " + from.getAbsolutePath() + " to " + to.getAbsolutePath(), ex);
                }
            }
            try {
                Files.move(from.toPath(), to.toPath(), new CopyOption[0]);
            }
            catch (IOException ex) {
                throw new ProcessException("Failed to move file " + from.getAbsolutePath() + " to " + to.getAbsolutePath(), ex);
            }
        }
    }

    private static class XSLTErrorListener
    implements ErrorListener {
        private final Logger log;

        XSLTErrorListener(Logger log) {
            this.log = log;
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            this.log.error("Transformer fatal error: {}", (Object)exception.getMessageAndLocation());
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
            this.log.warn("Transformer warning: {}", (Object)exception.getMessageAndLocation());
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
            this.log.error("Transformer error: {}", (Object)exception.getMessageAndLocation());
        }
    }
}

