/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.process.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.process.ProcessException;
import org.pageseeder.psml.process.util.XMLParserErrorHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class XMLUtils {
    private XMLUtils() {
    }

    public static String escape(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        if (s.indexOf(38) == -1 && s.indexOf(60) == -1) {
            return s;
        }
        StringBuilder valid = new StringBuilder(s);
        int shift = 0;
        block4: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '&': {
                    valid.insert(i + shift + 1, "amp;");
                    shift += 4;
                    continue block4;
                }
                case '<': {
                    valid.deleteCharAt(i + shift);
                    valid.insert(i + shift, "&lt;");
                    shift += 3;
                    continue block4;
                }
            }
        }
        return valid.toString();
    }

    public static String escapeForAttribute(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        if (s.indexOf(38) == -1 && s.indexOf(60) == -1 && s.indexOf(34) == -1) {
            return s;
        }
        StringBuilder valid = new StringBuilder(s);
        int shift = 0;
        block6: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '&': {
                    valid.insert(i + shift + 1, "amp;");
                    shift += 4;
                    continue block6;
                }
                case '\"': {
                    valid.deleteCharAt(i + shift);
                    valid.insert(i + shift, "&quot;");
                    shift += 5;
                    continue block6;
                }
                case '\'': {
                    valid.deleteCharAt(i + shift);
                    valid.insert(i + shift, "&apos;");
                    shift += 5;
                    continue block6;
                }
                case '<': {
                    valid.deleteCharAt(i + shift);
                    valid.insert(i + shift, "&lt;");
                    shift += 3;
                    continue block6;
                }
            }
        }
        return valid.toString();
    }

    public static Transformer createTransformer(File xslt, @Nullable ErrorListener listener) throws ProcessException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            if (listener != null) {
                factory.setErrorListener(listener);
            }
            return factory.newTemplates(new StreamSource(xslt)).newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new ProcessException("Failed to load XSLT stylesheet: " + e.getMessageAndLocation(), e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new ProcessException("Failed to load XSLT stylesheet", e);
        }
    }

    public static void transform(File in, File out, Transformer t) throws ProcessException {
        XMLUtils.transform(in, out, t, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transform(File in, File out, Transformer t, @Nullable URL schema, @Nullable List<String> errors, @Nullable List<String> warnings) throws ProcessException {
        block24: {
            try {
                FileInputStream fis = new FileInputStream(in);
                FileOutputStream fos = new FileOutputStream(out);
                try {
                    SAXSource source = new SAXSource(XMLReaderFactory.createXMLReader(), new InputSource(fis));
                    source.setSystemId(in.toURI().toString());
                    t.transform(source, new StreamResult(fos));
                }
                finally {
                    fis.close();
                    fos.close();
                }
                if (schema == null) break block24;
                fis = new FileInputStream(out);
                try {
                    XMLReader reader = XMLReaderFactory.createXMLReader();
                    reader.setFeature("http://xml.org/sax/features/validation", true);
                    reader.setFeature("http://apache.org/xml/features/validation/schema", true);
                    reader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                    XMLParserErrorHandler errorHandler = new XMLParserErrorHandler();
                    reader.setErrorHandler(errorHandler);
                    String path = schema.toString().replaceAll(" ", "%20");
                    reader.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", path);
                    reader.parse(new InputSource(fis));
                    if (errors != null) {
                        errors.addAll(errorHandler.getErrors());
                    } else if (errorHandler.hasErrors()) {
                        StringBuilder all = new StringBuilder();
                        for (String e : errorHandler.getErrors()) {
                            all.append(e).append("\n");
                        }
                        throw new ProcessException("Error when validating " + out.getAbsolutePath() + ": " + all.toString());
                    }
                    if (warnings != null) {
                        warnings.addAll(errorHandler.getWarnings());
                    }
                }
                catch (SAXException ex) {
                    throw new ProcessException("Error when validating XSLT output: " + ex.getMessage(), ex);
                }
                catch (IOException ex) {
                    throw new ProcessException("Failed to read/write XML", ex);
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (IOException ex) {
                        throw new ProcessException("Failed to close XSLT output stream", ex);
                    }
                }
            }
            catch (SAXException ex) {
                throw new ProcessException("Failed to create XML reader for XSLT transformation", ex);
            }
            catch (TransformerConfigurationException ex) {
                throw new ProcessException("Failed to create XSLT transformer", ex);
            }
            catch (TransformerException ex) {
                throw new ProcessException("Failed to transform XML", ex);
            }
            catch (IOException ex) {
                throw new ProcessException("Failed to read/write XML", ex);
            }
        }
    }

    public static void parse(File in, ContentHandler handler) throws ProcessException {
        XMLUtils.parse(in, handler, null, null);
    }

    public static void parse(File in, ContentHandler handler, @Nullable List<String> errors, @Nullable List<String> warnings) throws ProcessException {
        try {
            XMLUtils.parse(new FileInputStream(in), handler, errors, warnings);
        }
        catch (FileNotFoundException ex) {
            throw new ProcessException("Invalid File " + in.getAbsolutePath(), ex);
        }
    }

    public static void parse(InputStream in, ContentHandler handler) throws ProcessException {
        XMLUtils.parse(in, handler, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(InputStream in, ContentHandler handler, @Nullable List<String> errors, @Nullable List<String> warnings) throws ProcessException {
        try {
            XMLUtils.parse(new InputSource(in), handler, errors, warnings);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                throw new ProcessException("Failed to close PSML: " + ex.getMessage(), ex);
            }
        }
    }

    public static void parse(InputSource in, ContentHandler handler, @Nullable List<String> errors, @Nullable List<String> warnings) throws ProcessException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            XMLReader reader = factory.newSAXParser().getXMLReader();
            reader.setContentHandler(handler);
            XMLParserErrorHandler errorHandler = new XMLParserErrorHandler();
            reader.setErrorHandler(errorHandler);
            reader.parse(in);
            if (errors != null) {
                errors.addAll(errorHandler.getErrors());
            } else if (errorHandler.hasErrors()) {
                StringBuilder all = new StringBuilder();
                for (String e : errorHandler.getErrors()) {
                    all.append(e).append("\n");
                }
                throw new ProcessException(all.toString());
            }
            if (warnings != null) {
                warnings.addAll(errorHandler.getWarnings());
            }
        }
        catch (IOException ex) {
            throw new ProcessException("Failed to read/write PSML: " + ex.getMessage(), ex);
        }
        catch (SAXException ex) {
            throw new ProcessException(ex.getMessage(), ex);
        }
        catch (ParserConfigurationException ex) {
            throw new ProcessException(ex.getMessage(), ex);
        }
    }
}

