/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.process;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.pageseeder.psml.process.NumberedTOCGenerator;
import org.pageseeder.psml.process.PSMLProcessHandler;
import org.pageseeder.psml.process.ProcessException;
import org.pageseeder.psml.process.util.XMLUtils;
import org.pageseeder.psml.toc.FragmentNumbering;
import org.pageseeder.psml.toc.PublicationConfig;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterImpl;
import org.slf4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class PSMLProcessHandler2
extends DefaultHandler {
    private static final String HREF_ATTRIBUTE = "href";
    private Logger logger = null;
    private Writer xml = null;
    private boolean failOnError = false;
    private boolean errorOnAmbiguous = false;
    private boolean warnOnAmbiguous = true;
    private boolean processed = true;
    private boolean processXRefs = true;
    private boolean relativiseImagePaths = true;
    private final String sourceRelativePath;
    private boolean generateTOC = false;
    private boolean tocWritten = false;
    boolean lastXRefTransclude = false;
    private Map<String, Map<String, Integer[]>> hierarchyUriFragIDs = new HashMap<String, Map<String, Integer[]>>();
    private PublicationConfig publicationConfig = null;
    private NumberedTOCGenerator numberingAndTOC = null;
    private Stack<String> ancestorUriIDs = new Stack();
    private Map<String, Integer> uriIDsAlreadyFound = new HashMap<String, Integer>();
    private Stack<String> elements = new Stack();
    private Stack<Location> locations = new Stack();
    private int previousheadingLevel = 0;
    private String resolvedXRefTemplate = null;
    private int xrefTargetPosition = 1;
    private DiffType xrefElementChange = null;
    private DiffElement insideDiffElement = null;
    private int alternateXRefs = 0;

    public PSMLProcessHandler2(Writer out, String relativePath) {
        this.xml = out;
        this.sourceRelativePath = relativePath;
    }

    public void setLogger(Logger log) {
        this.logger = log;
    }

    public void setFailOnError(boolean failonerror) {
        this.failOnError = failonerror;
    }

    public void setErrorOnAmbiguous(boolean error) {
        this.errorOnAmbiguous = error;
    }

    public void setWarnOnAmbiguous(boolean warn) {
        this.warnOnAmbiguous = warn;
    }

    public void setHierarchyUriFragIDs(Map<String, Map<String, Integer[]>> uriFragIDs) {
        this.hierarchyUriFragIDs = uriFragIDs;
    }

    public void setPublicationConfig(PublicationConfig config, NumberedTOCGenerator generator, boolean toc) {
        this.publicationConfig = config;
        this.numberingAndTOC = generator;
        this.generateTOC = toc;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public void setProcessXRefs(boolean process) {
        this.processXRefs = process;
    }

    public void setRelativiseImagePaths(boolean relativise) {
        this.relativiseImagePaths = relativise;
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.xml.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        }
        catch (IOException ex) {
            throw new SAXException("Failed to write XML declaration ", ex);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        Location location;
        boolean isPara;
        boolean noNamespace = uri == null || uri.isEmpty();
        boolean isXRef = noNamespace && ("blockxref".equals(qName) || "xref".equals(qName));
        boolean isReverseXRef = noNamespace && "reversexref".equals(qName);
        boolean isImage = noNamespace && "image".equals(qName);
        boolean isTOC = noNamespace && "toc".equals(qName);
        boolean isSection = noNamespace && "section".equals(qName);
        boolean isDocument = noNamespace && "document".equals(qName);
        boolean isFrag = noNamespace && ("fragment".equals(qName) || "media-fragment".equals(qName) || "xref-fragment".equals(qName) || "properties-fragment".equals(qName));
        boolean isHeading = noNamespace && "heading".equals(qName);
        boolean bl = isPara = noNamespace && "para".equals(qName);
        if (isDocument && atts.getValue("id") == null) {
            throw new SAXException("Document has no id attribute.");
        }
        DiffElement diffElement = "dfx:ins".equals(qName) ? DiffElement.INS : (this.insideDiffElement = "dfx:del".equals(qName) ? DiffElement.DEL : null);
        if (this.insideDiffElement == null) {
            this.resolvedXRefTemplate = null;
        }
        if (isXRef) {
            if (this.alternateXRefs > 0) {
                ++this.alternateXRefs;
            } else if ("alternate".equals(atts.getValue("type"))) {
                this.alternateXRefs = 1;
            }
        }
        if ("document-fragment".equals(qName)) {
            if (this.alternateXRefs == 0) {
                String uriid = atts.getValue("uriid");
                Integer count = this.uriIDsAlreadyFound.get(uriid);
                if (count == null) {
                    count = 0;
                }
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                this.uriIDsAlreadyFound.put(uriid, count);
                this.ancestorUriIDs.push(count + "_" + uriid);
                if (!this.lastXRefTransclude) {
                    this.locations.push(new Location(Long.parseLong(uriid), count));
                }
            }
            return;
        }
        this.elements.push(qName);
        try {
            this.xml.write("<" + qName);
        }
        catch (IOException ex) {
            throw new SAXException("Failed to open element " + qName, ex);
        }
        Location location2 = location = this.locations.isEmpty() ? null : this.locations.peek();
        if ((isHeading || isPara) && !this.elements.contains("compare") && this.numberingAndTOC != null && this.alternateXRefs == 0) {
            FragmentNumbering.Prefix pref;
            if (isHeading) {
                this.previousheadingLevel = Integer.parseInt(atts.getValue("level"));
            }
            ++location.index;
            String prefix = atts.getValue("prefix");
            if ("true".equals(atts.getValue("numbered")) && (pref = this.numberingAndTOC.fragmentNumbering().getTranscludedPrefix(location.uriid, location.position, location.fragment, location.index)) != null) {
                prefix = pref.value;
            }
            if (prefix != null) {
                try {
                    this.xml.write(" prefix=\"" + XMLUtils.escapeForAttribute(prefix) + "\"");
                }
                catch (IOException ex) {
                    throw new SAXException("Failed to add id attribute: " + ex.getMessage(), ex);
                }
            }
        }
        String xhref = atts.getValue("xhref");
        for (int i = 0; i < atts.getLength(); ++i) {
            Object value;
            String name = atts.getQName(i);
            if (isImage && HREF_ATTRIBUTE.equals(name) || isXRef && "xhref".equals(name)) continue;
            if (isImage && "src".equals(name) || isXRef && HREF_ATTRIBUTE.equals(name) && xhref != null) {
                try {
                    value = this.handleImage(atts.getValue(i), isImage ? atts.getValue(HREF_ATTRIBUTE) : xhref);
                }
                catch (ProcessException ex) {
                    if (this.failOnError) {
                        throw new SAXException("Failed to rewrite src attribute " + atts.getValue(i) + ": " + ex.getMessage(), ex);
                    }
                    if (this.logger != null) {
                        this.logger.warn("Failed to rewrite image src attribute " + atts.getValue(i) + ": " + ex.getMessage());
                    }
                    value = atts.getValue(i);
                }
            } else {
                Integer count;
                if ((isXRef || isReverseXRef) && "relpath".equals(name)) continue;
                if (isReverseXRef && HREF_ATTRIBUTE.equals(name) && this.processXRefs) {
                    String relpath = atts.getValue("relpath");
                    value = relpath == null ? atts.getValue(i) : this.URLEncodeIfNotProcessed(PSMLProcessHandler2.relativisePath(relpath, this.sourceRelativePath));
                } else if (isXRef && HREF_ATTRIBUTE.equals(name) && this.processXRefs) {
                    try {
                        value = this.handleXRef(atts);
                    }
                    catch (ProcessException e) {
                        throw new SAXException(e.getMessage(), e);
                    }
                } else if (isSection && "id".equals(name) && this.alternateXRefs == 0 && this.processXRefs) {
                    String uriid;
                    String id = atts.getValue(i);
                    int j = id.indexOf(45);
                    value = j != -1 ? ((count = this.uriIDsAlreadyFound.get(uriid = id.substring(0, j))) != 1 ? count + "_" + id : id) : id;
                } else if (isDocument && "id".equals(name) && this.alternateXRefs == 0) {
                    String id = atts.getValue(i);
                    Integer count2 = this.uriIDsAlreadyFound.get(id);
                    if (count2 == null) {
                        count2 = 0;
                    }
                    Integer uriid = count2;
                    count = count2 = Integer.valueOf(count2 + 1);
                    value = this.processXRefs ? (count2 != 1 ? count2 + "_" + id : id) : id;
                    this.uriIDsAlreadyFound.put(id, count2);
                    this.ancestorUriIDs.push(count2 + "_" + id);
                    if (!this.lastXRefTransclude) {
                        this.locations.push(new Location(Long.parseLong(id), count2));
                    }
                } else if (!this.elements.contains("compare")) {
                    if (isFrag && "id".equals(name) && this.alternateXRefs == 0 && (!"media-fragment".equals(qName) || !"media".equals(atts.getValue("id")))) {
                        String id = atts.getValue(i);
                        int j = id.indexOf(45);
                        if (j != -1) {
                            if (this.locations.peek().blockxrefs == 0) {
                                location.fragment = id.substring(j + 1);
                                location.index = 0;
                            }
                            String uriid = id.substring(0, j);
                            count = this.uriIDsAlreadyFound.get(uriid);
                            value = this.processXRefs ? (count != 1 ? count + "_" + id : id) : id;
                        } else {
                            if (this.locations.peek().blockxrefs == 0) {
                                location.fragment = id;
                                location.index = 0;
                            }
                            value = id;
                        }
                    } else {
                        if ((isHeading || isPara) && "prefix".equals(name) && !this.elements.contains("compare") && this.numberingAndTOC != null) continue;
                        if (isHeading && "level".equals(name) && this.numberingAndTOC != null && this.alternateXRefs == 0 && this.publicationConfig.getHeadingLevelAdjust() == PublicationConfig.LevelAdjust.CONTENT) {
                            int headingLevel = Integer.parseInt(atts.getValue(name));
                            FragmentNumbering.Prefix pref = this.numberingAndTOC.fragmentNumbering().getPrefix(location.uriid, location.position);
                            int base = pref == null ? 0 : pref.level;
                            value = String.valueOf((headingLevel += base - 1) > 0 ? headingLevel : 1);
                        } else if (isPara && "indent".equals(name) && this.numberingAndTOC != null && this.alternateXRefs == 0 && this.publicationConfig.getParaLevelAdjust() == PublicationConfig.LevelAdjust.CONTENT) {
                            int paraLevel = Integer.parseInt(atts.getValue(name));
                            FragmentNumbering.Prefix pref = this.numberingAndTOC.fragmentNumbering().getPrefix(location.uriid, location.position);
                            int base = pref == null ? 0 : pref.level;
                            paraLevel += base - 1;
                            if (this.publicationConfig.getParaLevelRelativeTo() == PublicationConfig.LevelRelativeTo.HEADING) {
                                paraLevel += this.previousheadingLevel;
                            }
                            value = String.valueOf(paraLevel > 0 ? paraLevel : 1);
                        } else {
                            value = atts.getValue(i);
                        }
                    }
                } else {
                    value = atts.getValue(i);
                }
            }
            try {
                this.xml.write(" " + name + "=\"" + XMLUtils.escapeForAttribute((String)value) + "\"");
                continue;
            }
            catch (IOException ex) {
                throw new SAXException("Failed to add attribute \"" + atts.getQName(i) + "\" to element " + qName, ex);
            }
        }
        if (isHeading && this.generateTOC && !this.elements.contains("compare") && this.alternateXRefs == 0) {
            try {
                this.xml.write(" id=\"" + XMLUtils.escapeForAttribute(location.uriid + "-" + location.position + "-" + location.fragment + "-" + location.index) + "\"");
            }
            catch (IOException ex) {
                throw new SAXException("Failed to add id attribute: " + ex.getMessage(), ex);
            }
        }
        try {
            this.xml.write(">");
        }
        catch (IOException ex) {
            throw new SAXException("Failed to open element " + qName, ex);
        }
        if (isTOC && this.generateTOC && !this.tocWritten) {
            XMLWriterImpl xmlwriter = new XMLWriterImpl(this.xml, true);
            try {
                this.numberingAndTOC.toXML((XMLWriter)xmlwriter);
                xmlwriter.flush();
            }
            catch (IOException ex) {
                throw new SAXException("Unable to write TOC: " + ex.getMessage(), ex);
            }
            this.tocWritten = true;
        }
        if ("blockxref".equals(qName) && !this.elements.contains("compare")) {
            ++this.locations.peek().blockxrefs;
            this.lastXRefTransclude = "transclude".equals(atts.getValue("type"));
        } else if ("xref".equals(qName) && ("template".equals(atts.getValue("display")) || "template".equals(atts.getValue("del:display"))) && this.numberingAndTOC != null) {
            String title;
            String string = title = atts.getValue("title") != null ? atts.getValue("title") : atts.getValue("del:title");
            if (title != null && title.matches(".*?((\\{prefix})|(\\{heading})|(\\{parentnumber})).*?")) {
                Long targeturiid;
                this.xrefElementChange = "true".equals(atts.getValue("dfx:insert")) ? DiffType.INSERT : ("true".equals(atts.getValue("dfx:delete")) ? DiffType.DELETE : ("true".equals(atts.getValue("ins:frag")) || "true".equals(atts.getValue("ins:uriid")) ? DiffType.CHANGE : null));
                String targetfrag = atts.getValue("frag") != null ? atts.getValue("frag") : atts.getValue("del:frag");
                String targeturi = atts.getValue("uriid") != null ? atts.getValue("uriid") : atts.getValue("del:uriid");
                Long l = targeturiid = targeturi != null ? Long.valueOf(Long.parseLong(targeturi)) : null;
                if (targeturiid != null && this.numberingAndTOC.publicationTree().containsTree(targeturiid)) {
                    FragmentNumbering.Prefix prefix = this.numberingAndTOC.fragmentNumbering().getPrefix(targeturiid, this.xrefTargetPosition, targetfrag, 1);
                    if (prefix == null) {
                        prefix = this.numberingAndTOC.fragmentNumbering().getPrefix(targeturiid, this.xrefTargetPosition, targetfrag, 2);
                    }
                    String newPrefix = prefix == null ? null : prefix.value;
                    String newHeading = this.numberingAndTOC.publicationTree().getFragmentHeading(targeturiid, targetfrag);
                    String newParentNumber = prefix == null ? null : prefix.parentNumber;
                    this.resolvedXRefTemplate = title.replaceAll("\\{prefix}", newPrefix == null ? "?" : XMLUtils.escape(newPrefix)).replaceAll("\\{heading}", newHeading == null ? "?" : newHeading).replaceAll("\\{parentnumber}", newParentNumber == null ? "" : XMLUtils.escape(newParentNumber));
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("blockxref".equals(qName) && !this.elements.contains("compare")) {
            --this.locations.peek().blockxrefs;
            this.lastXRefTransclude = false;
        } else if (!(this.resolvedXRefTemplate == null || this.xrefElementChange == DiffType.INSERT && this.insideDiffElement == DiffElement.DEL || this.xrefElementChange == DiffType.DELETE && this.insideDiffElement == DiffElement.INS)) {
            try {
                if (this.xrefElementChange == DiffType.CHANGE && this.insideDiffElement == null) {
                    this.xml.write("<dfx:ins>");
                    this.xml.write(this.resolvedXRefTemplate);
                    this.xml.write("</dfx:ins>");
                    this.xml.write("<dfx:del>x</dfx:del>");
                } else {
                    this.xml.write(this.resolvedXRefTemplate);
                }
            }
            catch (IOException ex) {
                throw new SAXException("Failed to write text", ex);
            }
            finally {
                this.resolvedXRefTemplate = null;
            }
        }
        if (("xref".equals(qName) || "blockxref".equals(qName)) && this.alternateXRefs > 0) {
            --this.alternateXRefs;
        }
        if ("xref".equals(qName)) {
            this.xrefElementChange = null;
        }
        if ("document-fragment".equals(qName)) {
            if (this.alternateXRefs == 0) {
                this.ancestorUriIDs.pop();
                if (this.locations.peek().blockxrefs == 0) {
                    this.locations.pop();
                    this.previousheadingLevel = 0;
                }
            }
            return;
        }
        if ("document".equals(qName) && this.alternateXRefs == 0) {
            this.ancestorUriIDs.pop();
            if (this.locations.peek().blockxrefs == 0) {
                this.locations.pop();
                this.previousheadingLevel = 0;
            }
        }
        this.elements.pop();
        try {
            this.xml.write("</" + qName + ">");
        }
        catch (IOException ex) {
            throw new SAXException("Failed to close element " + qName, ex);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.resolvedXRefTemplate == null && (this.xrefElementChange == DiffType.INSERT && this.insideDiffElement == DiffElement.INS || this.xrefElementChange == DiffType.DELETE && this.insideDiffElement == DiffElement.DEL)) {
            return;
        }
        try {
            if (this.resolvedXRefTemplate == null) {
                this.xml.write(XMLUtils.escape(new String(ch, start, length)));
            }
        }
        catch (IOException ex) {
            throw new SAXException("Failed to write text", ex);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.xml.flush();
        }
        catch (IOException ex) {
            throw new SAXException("Failed to flush XML writer ", ex);
        }
    }

    private String handleImage(String src, String href) throws ProcessException {
        this.logger.debug("Image temp href={}", (Object)href);
        if (!this.relativiseImagePaths || href == null) {
            return src;
        }
        String rel = this.URLEncodeIfNotProcessed(PSMLProcessHandler2.relativisePath(href, this.sourceRelativePath));
        this.logger.debug("Image relative path={}", (Object)rel);
        return rel;
    }

    private String handleXRef(Attributes atts) throws ProcessException, SAXException {
        String type = atts.getValue("type");
        String uriid = atts.getValue("uriid");
        String frag = atts.getValue("frag");
        if (frag == null) {
            throw new ProcessException("XRef has no frag attribute.");
        }
        Integer global_count = 0;
        Integer local_count = 0;
        Integer embed_count = 0;
        Integer[] uri_counts = null;
        if (uriid != null && "none".equals(type)) {
            ArrayList<String> ancestors = new ArrayList<String>(this.ancestorUriIDs);
            for (int i = ancestors.size() - 1; i >= 0; --i) {
                Integer[] frag_counts;
                String id = (String)ancestors.get(i);
                Map<String, Integer[]> sub_hierarchy = this.hierarchyUriFragIDs.get(id);
                if (sub_hierarchy == null) {
                    String message = "Unable to find subhierarchy for URI ID " + id;
                    if (this.failOnError) {
                        throw new ProcessException(message);
                    }
                    this.logger.error(message);
                    continue;
                }
                uri_counts = sub_hierarchy.get(uriid);
                if (uri_counts != null) {
                    global_count = uri_counts[0];
                    local_count = uri_counts[1];
                    embed_count = uri_counts[2];
                    this.logger.debug("Hierarchy {} found ID {} globally {}, locally {} and embedded {} times", new Object[]{id, uriid, uri_counts[0], uri_counts[1], uri_counts[2]});
                }
                if (!"default".equals(frag) && (frag_counts = sub_hierarchy.get(uriid + "-" + frag)) != null) {
                    global_count = frag_counts[0];
                    local_count = local_count + frag_counts[1];
                    embed_count = embed_count + frag_counts[2];
                    this.logger.debug("Hierarchy {} found fragment ID {}-{} globally {} times, locally {} and embedded {} times", new Object[]{id, uriid, frag, frag_counts[0], frag_counts[1], frag_counts[2]});
                }
                if (embed_count > 0 || local_count == 1) break;
            }
        }
        if (local_count > 0) {
            if (embed_count > 1 || embed_count == 0 && local_count > 1) {
                String message = "Internal link pointing to " + atts.getValue(HREF_ATTRIBUTE) + " (URIID " + uriid + ") fragment " + frag + " is ambiguous because this content appears in multiple locations. See xref" + (String)(atts.getValue("title") == null ? "" : " " + atts.getValue("title")) + " in document " + this.sourceRelativePath + (String)(this.ancestorUriIDs.isEmpty() ? "" : " (URIID " + this.ancestorUriIDs.peek() + ")") + ". This can be fixed by having the content embedded in one location and transcluded in the others.";
                PSMLProcessHandler.handleError(message, this.failOnError, this.logger, this.errorOnAmbiguous, this.warnOnAmbiguous);
            }
            if (uri_counts != null && uri_counts[2].intValue() > 0) {
                global_count = uri_counts[0];
            }
            this.xrefTargetPosition = global_count;
            if ("default".equals(frag)) {
                return "#" + (String)(global_count != 1 ? global_count + "_" : "") + uriid;
            }
            return "#" + (String)(global_count != 1 ? global_count + "_" : "") + uriid + "-" + frag;
        }
        String relpath = atts.getValue("relpath");
        if (relpath == null) {
            return atts.getValue(HREF_ATTRIBUTE);
        }
        return this.URLEncodeIfNotProcessed(PSMLProcessHandler2.relativisePath(relpath, this.sourceRelativePath));
    }

    private static String relativisePath(String path, String currentLocation) {
        StringBuilder relative = new StringBuilder();
        String[] pathElements = path.split("/");
        String[] thisElements = currentLocation.isEmpty() ? new String[]{} : currentLocation.split("/");
        for (int i = 0; i < pathElements.length; ++i) {
            int j;
            if (i < thisElements.length - 1 && pathElements[i].equals(thisElements[i])) continue;
            for (j = i; j < thisElements.length - 1; ++j) {
                relative.append("/..");
            }
            for (j = i; j < pathElements.length; ++j) {
                relative.append("/" + pathElements[j]);
            }
            break;
        }
        return relative.length() == 0 ? "" : relative.substring(1);
    }

    private String URLEncodeIfNotProcessed(String path) {
        if (!this.processed) {
            return PSMLProcessHandler.URLEncodeFilepath(path);
        }
        return path;
    }

    private final class Location {
        private long uriid;
        private int position;
        private String fragment = null;
        private int index = 0;
        int blockxrefs = 0;

        private Location(long uriid, int position) {
            this.uriid = uriid;
            this.position = position;
        }
    }

    private static enum DiffElement {
        INS,
        DEL;

    }

    private static enum DiffType {
        INSERT,
        DELETE,
        CHANGE;

    }
}

