/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.process;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.process.PSMLProcessHandler;
import org.pageseeder.psml.process.ProcessException;
import org.pageseeder.psml.process.config.Images;
import org.pageseeder.psml.process.util.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ImageCache {
    private final File metaInfFolder;
    private final Map<String, String> cache = new HashMap<String, String>();

    public ImageCache(File metaInf) {
        this.metaInfFolder = metaInf;
    }

    public boolean isCached(String relativePath) {
        return this.cache.containsKey(relativePath);
    }

    public String getImageNewPath(String relativePath) {
        return this.cache.get(relativePath);
    }

    public String getImageNewPath(String relativePath, Images.ImageSrc src) throws ProcessException {
        Object newpath = this.cache.get(relativePath);
        if (newpath == null) {
            File metadata = new File(this.metaInfFolder, relativePath + ".psml");
            if (!metadata.exists() || !metadata.isFile()) {
                throw new ProcessException("Image metadata file not found " + relativePath);
            }
            MetadataFileHandler handler = new MetadataFileHandler();
            XMLUtils.parse(metadata, (ContentHandler)handler);
            if (src == Images.ImageSrc.FILENAME) {
                int lastSlash = relativePath.lastIndexOf(47);
                String filename = lastSlash != -1 ? relativePath.substring(lastSlash + 1) : relativePath;
                newpath = this.buildUniqueFilename(filename);
                if (src == Images.ImageSrc.FILENAMEENCODE) {
                    newpath = PSMLProcessHandler.URLEncodeFilepath((String)newpath);
                }
            } else {
                newpath = src == Images.ImageSrc.URIIDFOLDERS ? ImageCache.buildURIIDFoldersPath(handler.getUriID()) + handler.getUriID() + "." + handler.getUriExtension() : handler.getUriID() + "." + handler.getUriExtension();
            }
            this.cache.put(relativePath, (String)newpath);
        }
        return newpath;
    }

    public String getImageNewPath(String relativePath, Images.ImageSrc src, String uriid) {
        Object newpath = this.cache.get(relativePath);
        if (newpath == null) {
            String extension;
            int lastDot = relativePath.lastIndexOf(46);
            String string = extension = lastDot != -1 ? relativePath.substring(lastDot) : "";
            if (src == Images.ImageSrc.FILENAME || src == Images.ImageSrc.FILENAMEENCODE) {
                int lastSlash = relativePath.lastIndexOf(47);
                String filename = lastSlash != -1 ? relativePath.substring(lastSlash + 1) : relativePath;
                newpath = this.buildUniqueFilename(filename);
                if (src == Images.ImageSrc.FILENAMEENCODE) {
                    newpath = PSMLProcessHandler.URLEncodeFilepath((String)newpath);
                }
            } else {
                newpath = src == Images.ImageSrc.URIIDFOLDERS ? ImageCache.buildURIIDFoldersPath(uriid) + uriid + extension : uriid + extension;
            }
            this.cache.put(relativePath, (String)newpath);
        }
        return newpath;
    }

    public void cacheImagePath(String relativePath) {
        this.cache.put(relativePath, relativePath);
    }

    public static String buildURIIDFoldersPath(String uriid) {
        String overflow = "";
        int len = ((String)uriid).length();
        if (len < 12) {
            uriid = "000000000000".substring(len) + (String)uriid;
        } else {
            overflow = ((String)uriid).substring(0, len - 12);
            uriid = ((String)uriid).substring(len - 12);
        }
        return overflow + ((String)uriid).substring(0, 3) + "/" + ((String)uriid).substring(3, 6) + "/" + ((String)uriid).substring(6, 9) + "/";
    }

    public String buildUniqueFilename(String filename) {
        int lastDot = filename.lastIndexOf(46);
        String extension = lastDot != -1 ? filename.substring(lastDot) : "";
        String name = lastDot != -1 ? filename.substring(0, lastDot) : filename;
        String namePrefix = name + "-";
        Set<String> keys = this.cache.keySet();
        int count = 0;
        for (String key : keys) {
            String keyname;
            int lastSlash = key.lastIndexOf(47);
            String string = keyname = lastSlash != -1 ? key.substring(lastSlash + 1) : key;
            if (!keyname.equals(filename) && !keyname.startsWith(namePrefix)) continue;
            ++count;
        }
        if (count == 0) {
            return filename;
        }
        return namePrefix + (count + 1) + extension;
    }

    private static class MetadataFileHandler
    extends DefaultHandler {
        private @Nullable String uriID = null;
        private @Nullable String uriExtension = null;
        private boolean inDocInfo = false;

        private MetadataFileHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("documentinfo".equals(qName)) {
                this.inDocInfo = true;
            } else if (this.inDocInfo && "uri".equals(qName)) {
                this.uriID = attributes.getValue("id");
                String path = attributes.getValue("path");
                if (path != null) {
                    String[] parts = path.split("/");
                    String last = parts[parts.length - 1];
                    this.uriExtension = last.substring(last.lastIndexOf(46) + 1);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("documentinfo".equals(qName)) {
                this.inDocInfo = false;
            }
        }

        public @Nullable String getUriExtension() {
            return this.uriExtension;
        }

        public @Nullable String getUriID() {
            return this.uriID;
        }
    }
}

