/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.model;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.model.PSMLElement;
import org.pageseeder.psml.model.PSMLText;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class Loader {
    private @Nullable SAXParserFactory factory = null;
    private boolean preserveWhitespace = false;

    public Loader() {
    }

    public Loader(boolean ignoreWhitespace) {
        this.preserveWhitespace = ignoreWhitespace;
    }

    public void setPreserveWhitespace(boolean preserveWhitespace) {
        this.preserveWhitespace = preserveWhitespace;
    }

    public boolean isPreserveWhitespace() {
        return this.preserveWhitespace;
    }

    public PSMLElement parse(Reader reader) throws IOException {
        InputSource source = new InputSource(reader);
        return this.parse(source);
    }

    public PSMLElement parse(InputSource source) throws IOException {
        Handler handler = new Handler(this.preserveWhitespace);
        if (this.factory == null) {
            SAXParserFactory f = SAXParserFactory.newInstance();
            f.setNamespaceAware(true);
            f.setValidating(false);
            this.factory = f;
        }
        try {
            SAXParser parser = this.factory.newSAXParser();
            parser.parse(source, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new IOException(ex);
        }
        return handler.result;
    }

    public static final class Handler
    extends DefaultHandler {
        private final boolean preserveWhitespace;
        private final List<PSMLElement> context = new ArrayList<PSMLElement>(8);
        private final StringBuilder text = new StringBuilder();
        private PSMLElement result = new PSMLElement(PSMLElement.Name.UNKNOWN);

        public Handler(boolean preserveWhitespace) {
            this.preserveWhitespace = preserveWhitespace;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.commitText();
            PSMLElement element = new PSMLElement(PSMLElement.Name.forElement(qName));
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getQName(i);
                String value = attributes.getValue(i);
                element.setAttribute(name, value);
            }
            this.push(element);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.commitText();
            PSMLElement element = this.pop();
            PSMLElement parent = this.current();
            if (parent != null) {
                parent.addNode(element);
            } else {
                this.result = element;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.text.append(ch, start, length);
        }

        private @Nullable PSMLElement current() {
            if (this.context.isEmpty()) {
                return null;
            }
            return this.context.get(this.context.size() - 1);
        }

        private PSMLElement pop() {
            return this.context.remove(this.context.size() - 1);
        }

        private void push(PSMLElement element) {
            this.context.add(element);
        }

        private void commitText() {
            PSMLElement current = this.current();
            if (current != null && this.text.length() > 0) {
                if (this.preserveWhitespace || !Handler.isIgnorableSpace(this.text, current)) {
                    current.addNode(new PSMLText(this.text.toString()));
                }
                this.text.setLength(0);
            }
        }

        private static boolean isIgnorableSpace(CharSequence text, PSMLElement element) {
            return Handler.isWhiteSpace(text) && element.isAnyElement(PSMLElement.Name.DOCUMENT, PSMLElement.Name.DOCUMENTINFO, PSMLElement.Name.SECTION, PSMLElement.Name.FRAGMENT, PSMLElement.Name.XREF_FRAGMENT, PSMLElement.Name.PROPERTIES_FRAGMENT, PSMLElement.Name.TABLE, PSMLElement.Name.ROW, PSMLElement.Name.LIST, PSMLElement.Name.NLIST);
        }

        private static boolean isWhiteSpace(CharSequence text) {
            for (int i = 0; i < text.length(); ++i) {
                if (Character.isWhitespace(text.charAt(i))) continue;
                return false;
            }
            return true;
        }
    }
}

