/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.diff;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import org.pageseeder.diffx.DiffException;
import org.pageseeder.diffx.action.OperationsBuffer;
import org.pageseeder.diffx.algorithm.DataLengthException;
import org.pageseeder.diffx.algorithm.MatrixXMLAlgorithm;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.config.DiffConfig;
import org.pageseeder.diffx.config.TextGranularity;
import org.pageseeder.diffx.config.WhiteSpaceProcessing;
import org.pageseeder.diffx.format.DefaultXMLDiffOutput;
import org.pageseeder.diffx.format.XMLDiffOutput;
import org.pageseeder.diffx.handler.CoalescingFilter;
import org.pageseeder.diffx.load.SAXLoader;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.xml.NamespaceSet;
import org.pageseeder.diffx.xml.Sequence;
import org.pageseeder.psml.diff.BlockLabelNormalizer;
import org.pageseeder.psml.diff.CellNormalizer;
import org.pageseeder.psml.diff.ElementDenormalizer;
import org.pageseeder.psml.diff.GasherbrumVAlgorithm;
import org.pageseeder.psml.diff.ListNormalizer;
import org.pageseeder.psml.diff.PSMLWhiteSpaceStripper;
import org.pageseeder.xmlwriter.UndeclaredNamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PSMLDiffer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PSMLDiffer.class);
    private DiffConfig config;
    private final int maxEvents;

    public PSMLDiffer(int maxEvents) {
        this.maxEvents = maxEvents;
        this.config = DiffConfig.getDefault().granularity(TextGranularity.SPACE_WORD).whitespace(WhiteSpaceProcessing.PRESERVE);
    }

    public void setWhiteSpaceProcessing(WhiteSpaceProcessing whitespace) {
        this.config = this.config.whitespace(whitespace);
    }

    public void setGranularity(TextGranularity granularity) {
        this.config = this.config.granularity(granularity);
    }

    public void diff(Reader xml1, Reader xml2, Writer out) throws DiffException, IOException {
        LOGGER.debug("Diff-X config: {} {}", (Object)this.config.granularity(), (Object)this.config.whitespace());
        if (LOGGER.isDebugEnabled()) {
            String source1 = PSMLDiffer.toString(xml1);
            String source2 = PSMLDiffer.toString(xml2);
            LOGGER.debug("XML Source B:\n{}", (Object)source1);
            LOGGER.debug("XML Source A:\n{}", (Object)source2);
            this.loadAndDiff(new StringReader(source2), new StringReader(source1), out);
        } else {
            this.loadAndDiff(xml2, xml1, out);
        }
    }

    private void loadAndDiff(Reader from, Reader to, Writer out) throws DiffException, IOException {
        SAXLoader loader = new SAXLoader();
        loader.setConfig(this.config);
        Sequence seqB = this.normalize(loader.load(to));
        Sequence seqA = this.normalize(loader.load(from));
        LOGGER.debug("Sequence A: {} (granularity={})", (Object)seqA.size(), (Object)this.config.granularity());
        LOGGER.debug("Sequence B: {} (granularity={})", (Object)seqB.size(), (Object)this.config.granularity());
        try {
            this.diff(seqA, seqB, out);
        }
        catch (DataLengthException ex) {
            throw new DiffException("There are over " + ex.getThreshold() + " points of comparison (" + ex.getSize() + ") reducing the fragment size will allow the comparison to be calculated.");
        }
        catch (UndeclaredNamespaceException ex) {
            throw new DiffException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    private Sequence normalize(Sequence seq) {
        PSMLWhiteSpaceStripper stripper = new PSMLWhiteSpaceStripper();
        BlockLabelNormalizer blocks = BlockLabelNormalizer.forPsml();
        CellNormalizer cells = new CellNormalizer();
        ListNormalizer lists = new ListNormalizer();
        return lists.process(cells.process(blocks.process(stripper.process(seq))));
    }

    private void diff(Sequence from, Sequence to, Writer out) throws DataLengthException {
        DefaultXMLDiffOutput output = new DefaultXMLDiffOutput(out);
        output.setWriteXMLDeclaration(false);
        NamespaceSet namespaces = NamespaceSet.merge((NamespaceSet)to.getNamespaces(), (NamespaceSet)from.getNamespaces());
        output.setNamespaces(namespaces);
        this.diffWithFallback(from, to, (XMLDiffOutput)output);
    }

    private void diffWithFallback(Sequence from, Sequence to, XMLDiffOutput output) {
        OperationsBuffer buffer = new OperationsBuffer();
        boolean successful = this.diffGasherbrum((List<? extends XMLToken>)from, (List<? extends XMLToken>)to, (DiffHandler<XMLToken>)buffer);
        if (!successful) {
            LOGGER.info("Gasherbrum diff failed! Falling back to matrix-based diff");
            buffer = new OperationsBuffer();
            this.diffMatrixXML((List<? extends XMLToken>)from, (List<? extends XMLToken>)to, (DiffHandler<XMLToken>)buffer, false);
        }
        buffer.applyTo((DiffHandler)new ElementDenormalizer((DiffHandler<XMLToken>)new CoalescingFilter((DiffHandler)output)));
    }

    private boolean diffGasherbrum(List<? extends XMLToken> from, List<? extends XMLToken> to, DiffHandler<XMLToken> handler) {
        GasherbrumVAlgorithm algorithm = new GasherbrumVAlgorithm(0.5f);
        algorithm.diff(from, to, handler);
        return !algorithm.hasError();
    }

    private void diffMatrixXML(List<? extends XMLToken> from, List<? extends XMLToken> to, DiffHandler<XMLToken> handler, boolean coalesced) {
        MatrixXMLAlgorithm algorithm = new MatrixXMLAlgorithm();
        algorithm.setThreshold(this.maxEvents);
        if (algorithm.isDiffComputable(from, to)) {
            handler.start();
            algorithm.diff(from, to, handler);
            handler.end();
        } else if (!coalesced) {
            LOGGER.debug("Coalescing content to");
            List a = CoalescingFilter.coalesce(from);
            List b = CoalescingFilter.coalesce(to);
            this.diffMatrixXML(a, b, handler, true);
        } else {
            throw new DataLengthException(from.size() * to.size(), this.maxEvents);
        }
    }

    private static String toString(Reader input) throws IOException {
        int n;
        StringBuilder out = new StringBuilder();
        char[] buffer = new char[1024];
        while ((n = input.read(buffer)) != -1) {
            out.append(buffer, 0, n);
        }
        return out.toString();
    }
}

