/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.diff;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.diffx.config.TextGranularity;
import org.pageseeder.diffx.config.WhiteSpaceProcessing;
import org.pageseeder.psml.diff.CompareHandler;
import org.pageseeder.psml.diff.DiffException;
import org.pageseeder.psml.diff.DiffHandler;
import org.pageseeder.psml.diff.PSMLDiffer;
import org.pageseeder.psml.process.util.Files;
import org.pageseeder.psml.process.util.IncludesExcludesMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class Diff {
    private @Nullable Logger logger = null;
    private @Nullable File src = null;
    private @Nullable File dest = null;
    private int maxEvents = 4000000;
    private WhiteSpaceProcessing whiteSpaceProcessing = WhiteSpaceProcessing.PRESERVE;
    private TextGranularity textGranularity = TextGranularity.SPACE_WORD;
    private @Nullable IncludesExcludesMatcher filesMatcher = null;

    public void setDest(File destination) {
        this.dest = destination;
    }

    public void setSrc(File source) {
        this.src = source;
    }

    public void setLogger(Logger log) {
        this.logger = log;
    }

    public void setFilesMatcher(IncludesExcludesMatcher matcher) {
        this.filesMatcher = matcher;
    }

    public void setWhiteSpaceProcessing(WhiteSpaceProcessing whitespace) {
        this.whiteSpaceProcessing = whitespace;
    }

    public void setGranularity(TextGranularity granularity) {
        this.textGranularity = granularity;
    }

    public void setMaxEvents(int maxevents) {
        this.maxEvents = maxevents;
    }

    public void addDiffElements(boolean outputAll) throws DiffException {
        if (this.src == null) {
            throw new DiffException("Src must be specified");
        }
        if (!this.src.exists() || !this.src.isDirectory()) {
            throw new DiffException("Invalid src location");
        }
        if (this.dest == null) {
            throw new DiffException("Dest must be specified");
        }
        if (!this.dest.exists() || !this.dest.isDirectory()) {
            throw new DiffException("Invalid destination folder");
        }
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(Diff.class);
        }
        this.logger.debug("Collecting PSML files from {}", (Object)this.src.getAbsolutePath());
        HashMap<String, File> psml = new HashMap<String, File>();
        this.collectAll(this.src, psml);
        for (Map.Entry psmlEntry : psml.entrySet()) {
            Map<String, String> compareFragments;
            boolean matches;
            String relPath = (String)psmlEntry.getKey();
            boolean bl = matches = this.filesMatcher == null || !this.filesMatcher.hasPatterns() || this.filesMatcher.matches(relPath);
            if (!matches) continue;
            this.logger.debug("Checking file {}", (Object)relPath);
            try (FileInputStream input = new FileInputStream((File)psmlEntry.getValue());){
                compareFragments = this.comparePSML(input);
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                this.logger.error("Failed to parse input file {}: {}", (Object)relPath, (Object)ex.getMessage());
                throw new DiffException("Failed to parse input file " + relPath + " : " + ex.getMessage(), ex);
            }
            if (compareFragments.isEmpty() && !outputAll) continue;
            this.logger.debug("Diffing file {}", (Object)relPath);
            FileOutputStream fos = null;
            try (FileInputStream input = new FileInputStream((File)psmlEntry.getValue());){
                File output = new File(this.dest, relPath);
                output.getParentFile().mkdirs();
                if (!output.exists() && !output.createNewFile()) {
                    throw new DiffException("Failed to create output file " + output.getAbsolutePath());
                }
                fos = new FileOutputStream(output);
                this.diffPSML(input, new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8), compareFragments);
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                this.logger.error("Failed to create output file: {}", (Object)ex.getMessage(), (Object)ex);
                throw new DiffException("Failed to create output file: " + ex.getMessage(), ex);
            }
            finally {
                try {
                    if (fos == null) continue;
                    fos.close();
                }
                catch (IOException ex) {
                    throw new DiffException("Failed to close output stream: " + ex.getMessage(), ex);
                }
            }
        }
    }

    public Map<String, String> comparePSML(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        CompareHandler handler = new CompareHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        parser.parse(in, (DefaultHandler)handler);
        return handler.getCompareFragments();
    }

    public void diffPSML(InputStream in, Writer out, Map<String, String> compareFragments) throws ParserConfigurationException, SAXException, IOException {
        PSMLDiffer differ = new PSMLDiffer(this.maxEvents);
        differ.setWhiteSpaceProcessing(this.whiteSpaceProcessing);
        differ.setGranularity(this.textGranularity);
        DiffHandler handler = new DiffHandler(out, compareFragments, differ);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        parser.parse(in, (DefaultHandler)handler);
        out.flush();
    }

    private void collectAll(File file, Map<String, File> psml) {
        this.collectFiles(file, file, psml, true);
    }

    private void collectFiles(File file, File root, Map<String, File> psml, boolean isRoot) {
        if (file.isDirectory()) {
            File[] all = file.listFiles();
            if (all != null) {
                for (File f : all) {
                    if (isRoot && "META-INF".equals(f.getName())) continue;
                    this.collectFiles(f, root, psml, false);
                }
            }
        } else if (file.isFile() && file.getName().toLowerCase().endsWith(".psml")) {
            psml.put(Files.computeRelativePath(file, root), file);
        }
    }
}

