/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.xml;

import com.pageseeder.common.xml.PredefinedEntity;
import org.eclipse.jdt.annotation.Nullable;

public final class XMLUtils {
    private static final int BYTE_ORDER_MARK = 65279;

    private XMLUtils() {
    }

    public static @Nullable StringBuilder removeXMLDeclaration(@Nullable StringBuilder sb) {
        if (sb == null) {
            return null;
        }
        int offset = 0;
        int length = sb.length();
        String xmlDeclStart = "<?xml";
        int len = xmlDeclStart.length();
        int start = 0;
        if (sb.charAt(0) == '\ufeff') {
            start = 1;
        }
        if (length > len && sb.subSequence(start, len + start).toString().equalsIgnoreCase(xmlDeclStart)) {
            for (int i = start; i < start + length - 1; ++i) {
                if (sb.charAt(i) != '?' || sb.charAt(i + 1) != '>') continue;
                offset = start + i + 2;
                break;
            }
        }
        sb.delete(0, offset);
        return sb;
    }

    public static @Nullable StringBuilder removeDoctypes(@Nullable StringBuilder sb) {
        if (sb == null) {
            return null;
        }
        int start = 0;
        int end = 0;
        int maxlookup = 500;
        int length = Math.min(sb.length(), 500);
        String doctype = "<!DOCTYPE";
        int len = doctype.length();
        block0: for (int i = 1; i < length; ++i) {
            if (sb.charAt(i) != '!' || i + len >= length || !sb.subSequence(i - 1, i - 1 + len).toString().equals(doctype)) continue;
            boolean ready = true;
            start = i - 1;
            for (int j = i + len; j < length; ++j) {
                char c = sb.charAt(j);
                if (c == '[') {
                    ready = false;
                }
                if (!ready && c == ']') {
                    ready = true;
                }
                if (!ready || c != '>') continue;
                end += j + 1;
                i = j;
                continue block0;
            }
        }
        sb.delete(start, end);
        return sb;
    }

    public static String escapeText(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        if (text.indexOf(38) == -1 && text.indexOf(60) == -1) {
            return text;
        }
        StringBuilder valid = new StringBuilder(text);
        int shift = 0;
        block4: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '&': {
                    valid.deleteCharAt(i + shift);
                    valid.insert(i + shift, PredefinedEntity.AMP.entity());
                    shift += PredefinedEntity.AMP.entity().length() - 1;
                    continue block4;
                }
                case '<': {
                    valid.deleteCharAt(i + shift);
                    valid.insert(i + shift, PredefinedEntity.LT.entity());
                    shift += PredefinedEntity.LT.entity().length() - 1;
                    continue block4;
                }
            }
        }
        return valid.toString();
    }

    public static String escapeAttValue(@Nullable String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        if (value.indexOf(38) == -1 && value.indexOf(60) == -1 && value.indexOf(39) == -1 && value.indexOf(34) == -1) {
            return value;
        }
        StringBuilder out = new StringBuilder(value.length() + 8);
        block6: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    out.append(PredefinedEntity.AMP.entity());
                    continue block6;
                }
                case '<': {
                    out.append(PredefinedEntity.LT.entity());
                    continue block6;
                }
                case '\'': {
                    out.append(PredefinedEntity.APOS.entity());
                    continue block6;
                }
                case '\"': {
                    out.append(PredefinedEntity.QUOT.entity());
                    continue block6;
                }
                default: {
                    out.append(c);
                }
            }
        }
        return out.toString();
    }
}

