/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.xml;

import com.pageseeder.common.util.CollectedError;
import com.pageseeder.common.util.ErrorCollector;
import org.slf4j.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public final class SAXErrorCollector
extends ErrorCollector<SAXParseException>
implements ErrorHandler {
    private static final String LOG_FORMAT = "{} (line: {})";
    private final Logger logger;

    public SAXErrorCollector(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXParseException {
        this.logger.error(LOG_FORMAT, (Object)exception.getMessage(), (Object)exception.getLineNumber());
        this.collect(CollectedError.Level.FATAL, exception);
    }

    @Override
    public void error(SAXParseException exception) throws SAXParseException {
        this.logger.error(LOG_FORMAT, (Object)exception.getMessage(), (Object)exception.getLineNumber());
        this.collect(CollectedError.Level.ERROR, exception);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXParseException {
        this.logger.warn(LOG_FORMAT, (Object)exception.getMessage(), (Object)exception.getLineNumber());
        this.collect(CollectedError.Level.WARNING, exception);
    }
}

