/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.util;

import com.pageseeder.common.properties.GlobalSettings;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipChecker.class);
    private static final int DEFAULT_MAX_ENTRIES = 1000000;
    public static final long DEFAULT_MAX_UPLOAD_SIZE = 100000000L;
    private static final long DEFAULT_MAX_RATIO = 100L;
    private final File zipFile;
    private final int maxEntries;
    private final long maxUncompressedSize;
    private final long maxRatio;
    private @Nullable String error = null;

    public ZipChecker(File zip) {
        this(zip, 1000000, GlobalSettings.getLong("maxUploadSize", 100000000L) * 10L, 100L);
    }

    public ZipChecker(File zip, int maxEntries, long maxUncompressedSize, long maxRatio) {
        this.zipFile = zip;
        this.maxEntries = maxEntries;
        this.maxRatio = maxRatio;
        this.maxUncompressedSize = maxUncompressedSize;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public @Nullable String getError() {
        return this.error;
    }

    public void check() {
        long compressedSize = this.zipFile.length();
        long uncompressedSize = 0L;
        try (ZipFile zip = new ZipFile(this.zipFile);){
            if (zip.size() > this.maxEntries) {
                this.error = "ZIP file contain too many entries";
                return;
            }
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                long size = entry.getSize();
                if (size != -1L) {
                    uncompressedSize += size;
                }
                if (uncompressedSize > this.maxUncompressedSize) {
                    this.error = "Uncompressed data exceeds maximum size allowed";
                    return;
                }
                if (uncompressedSize / compressedSize <= this.maxRatio) continue;
                this.error = "Uncompressed data exceeds maximum ratio allowed";
                return;
            }
        }
        catch (ZipException ex) {
            this.error = "Failed to load the ZIP file contents";
            LOGGER.error("Failed to load ZIP file {}", (Object)this.zipFile.getAbsolutePath(), (Object)ex);
        }
        catch (IOException ex) {
            this.error = "Failed to read the ZIP file contents";
            LOGGER.error("Failed to read ZIP file {}", (Object)this.zipFile.getAbsolutePath(), (Object)ex);
        }
    }
}

