/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.jdt.annotation.Nullable;

public enum ISO8601 {
    YEAR("yyyy"){

        @Override
        public boolean isParsable(@Nullable String date) {
            return date != null && date.length() == 4 && ISO8601.isYearComponent(date);
        }
    }
    ,
    CALENDAR_DATE("yyyy-MM-dd"){

        @Override
        public boolean isParsable(@Nullable String date) {
            return date != null && date.length() == 10 && ISO8601.isDateComponent(date);
        }
    }
    ,
    WEEK_DATE("yyyy-'W'ww-d"){

        @Override
        public boolean isParsable(@Nullable String date) {
            if (date == null || date.length() != 10) {
                return false;
            }
            if (date.charAt(4) != '-' && date.charAt(5) != 'W') {
                return false;
            }
            if (!ISO8601.isYearComponent(date) || !ISO8601.isWeekComponent(date, 6)) {
                return false;
            }
            char dayOfWeek = date.charAt(date.length() - 1);
            return dayOfWeek > '0' && dayOfWeek <= '7';
        }
    }
    ,
    TIME("HH:mm:ss"){

        @Override
        public boolean isParsable(@Nullable String date) {
            return date != null && date.length() == 8 && ISO8601.isTimeComponent(date, 0);
        }
    }
    ,
    DATETIME("yyyy-MM-dd'T'HH:mm:ssZ"){

        @Override
        public boolean isParsable(@Nullable String date) {
            boolean isDateTime;
            if (date == null) {
                return false;
            }
            int length = date.length();
            if (length < 19) {
                return false;
            }
            if (date.charAt(10) != 'T') {
                return false;
            }
            boolean bl = isDateTime = ISO8601.isDateComponent(date) && ISO8601.isTimeComponent(date, 11);
            if (length == 19) {
                return isDateTime;
            }
            if (length == 25) {
                return isDateTime && ISO8601.isTimezoneComponent(date, 19);
            }
            if (length == 20 && date.charAt(19) == 'Z') {
                return isDateTime;
            }
            return false;
        }
    };

    private static final int YEAR_LENGTH = 4;
    private static final int DATE_LENGTH = 10;
    private static final int TIME_LENGTH = 8;
    private static final int DATETIME_LENGTH = 19;
    private static final int DATETIMEZONE_LENGTH = 25;
    private final String format;
    private final boolean hasTimeZone;
    private final Calendar calendar = Calendar.getInstance();

    private ISO8601(String format) {
        this.format = format;
        this.hasTimeZone = format.charAt(format.length() - 1) == 'Z';
    }

    public String format(long date) {
        SimpleDateFormat iso = new SimpleDateFormat(this.format);
        return this.hasTimeZone ? ISO8601.adjustTimezone(iso.format(date)) : iso.format(date);
    }

    public String format(long datetime, int offset) {
        return this.doFormat(new Date(datetime), offset);
    }

    public @Nullable String format(@Nullable Date date, int offset) {
        if (date == null) {
            return null;
        }
        return this.doFormat(date, offset);
    }

    private String doFormat(Date date, int offset) {
        SimpleDateFormat iso = new SimpleDateFormat(this.format);
        TimeZone tz = TimeZone.getDefault();
        int one_hour_in_millis = 3600000;
        tz.setRawOffset(tz.inDaylightTime(date) ? offset - 3600000 : offset);
        iso.setTimeZone(tz);
        return this.hasTimeZone ? ISO8601.adjustTimezone(iso.format(date)) : iso.format(date);
    }

    public abstract boolean isParsable(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parse(String date) throws ParseException {
        String parsable = date;
        if (this.isParsable((String)date)) {
            if (((String)date).charAt(((String)date).length() - 1) == 'Z') {
                date = ((String)date).substring(0, ((String)date).length() - 1) + "+00:00";
            }
            if (this.hasTimeZone) {
                Calendar calendar = this.calendar;
                synchronized (calendar) {
                    return ISO8601.parseDateTime((String)date, this.calendar);
                }
            }
            SimpleDateFormat iso = new SimpleDateFormat(this.format);
            return iso.parse(parsable);
        }
        throw new ParseException("Invalid ISO8601 " + this.name() + " format: \"" + (String)date + "\"", 0);
    }

    public static String format(long date, ISO8601 format) {
        return format.format(date);
    }

    public static Date parseAuto(String date) throws ParseException {
        ISO8601 format = ISO8601.detectFormat(date);
        if (format == null) {
            throw new ParseException("Invalid ISO8601 date format: \"" + date + "\"", 0);
        }
        return format.parse(date);
    }

    public static boolean isParsable(String date, ISO8601 format) {
        ISO8601 f = ISO8601.detectFormat(date);
        return f == format && f.isParsable(date);
    }

    public static @Nullable ISO8601 detectFormat(@Nullable String date) {
        if (date == null) {
            return null;
        }
        int length = date.length();
        switch (length) {
            case 4: {
                return YEAR;
            }
            case 8: {
                return TIME;
            }
            case 10: {
                return date.indexOf(87) == -1 ? CALENDAR_DATE : WEEK_DATE;
            }
            case 19: {
                return DATETIME;
            }
            case 20: {
                return DATETIME;
            }
            case 25: {
                return DATETIME;
            }
        }
        return null;
    }

    public static String today() {
        return CALENDAR_DATE.format(System.currentTimeMillis());
    }

    public static String now() {
        return DATETIME.format(System.currentTimeMillis());
    }

    private static Date parseDateTime(String datetime, Calendar calendar) throws NumberFormatException {
        int year = Integer.parseInt(datetime.substring(0, 4));
        int month = ISO8601.toInt2(datetime, 5) - 1;
        int dayOfMonth = ISO8601.toInt2(datetime, 8);
        int hourOfDay = ISO8601.toInt2(datetime, 11);
        int minute = ISO8601.toInt2(datetime, 14);
        int second = ISO8601.toInt2(datetime, 17);
        calendar.set(year, month, dayOfMonth, hourOfDay, minute, second);
        calendar.set(14, 0);
        if (datetime.length() > 19) {
            return Date.from(OffsetDateTime.parse(datetime).toInstant());
        }
        return calendar.getTime();
    }

    private static String adjustTimezone(String date) {
        return date.substring(0, date.length() - 2) + ":" + date.substring(date.length() - 2);
    }

    private static boolean isDateComponent(String date) {
        if (date.length() < 10) {
            return false;
        }
        if (!ISO8601.isYearComponent(date)) {
            return false;
        }
        if (date.charAt(4) != '-') {
            return false;
        }
        if (!ISO8601.isMonthComponent(date, 5)) {
            return false;
        }
        if (date.charAt(7) != '-') {
            return false;
        }
        return ISO8601.isDayComponent(date, 8);
    }

    private static boolean isTimeComponent(String time, int start) {
        if (start < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (time.length() - start < 8) {
            return false;
        }
        if (time.charAt(start + 2) != ':' || time.charAt(start + 5) != ':') {
            return false;
        }
        if (!ISO8601.isHourComponent(time, start)) {
            return false;
        }
        if (!ISO8601.isMinuteComponent(time, start + 3)) {
            return false;
        }
        return ISO8601.isSecondComponent(time, start + 8 - 2);
    }

    private static boolean isYearComponent(String s) {
        for (int i = 0; i < 4; ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private static boolean isMonthComponent(String s, int start) {
        char a = s.charAt(start);
        char b = s.charAt(start + 1);
        if (a < '0' || a > '1') {
            return false;
        }
        return a == '1' ? b >= '0' && b <= '2' : b >= '1' && b <= '9';
    }

    private static boolean isDayComponent(String s, int start) {
        char a = s.charAt(start);
        char b = s.charAt(start + 1);
        if (a < '0' || a > '3') {
            return false;
        }
        if (a == '3') {
            return b >= '0' && b <= '1';
        }
        if (a == '0') {
            return b >= '1' && b <= '9';
        }
        return b >= '0' && b <= '9';
    }

    private static boolean isWeekComponent(String s, int start) {
        char a = s.charAt(start);
        char b = s.charAt(start + 1);
        if (a < '0' || a > '5') {
            return false;
        }
        if (a == '5') {
            return b >= '0' && b <= '3';
        }
        if (a == '0') {
            return b >= '1' && b <= '9';
        }
        return b >= '0' && b <= '9';
    }

    private static boolean isHourComponent(String s, int start) {
        char a = s.charAt(start);
        char b = s.charAt(start + 1);
        if (a < '0' || a > '2') {
            return false;
        }
        if (b < '0') {
            return false;
        }
        return a == '2' ? b <= '4' : b <= '9';
    }

    private static boolean isTimezoneComponent(String s, int start) {
        char sign = s.charAt(start);
        if (sign != '-' && sign != '+') {
            return false;
        }
        if (s.charAt(start + 3) != ':') {
            return false;
        }
        return ISO8601.isHourComponent(s, start + 1) && ISO8601.isMinuteComponent(s, start + 4);
    }

    private static boolean isMinuteComponent(String s, int start) {
        char a = s.charAt(start);
        char b = s.charAt(start + 1);
        return a >= '0' && a <= '5' && b >= '0' && b <= '9';
    }

    private static boolean isSecondComponent(String s, int start) {
        char a = s.charAt(start);
        char b = s.charAt(start + 1);
        if (a < '0' || a > '6') {
            return false;
        }
        if (b < '0' || b > '9') {
            return false;
        }
        if (a == '6') {
            return b == '0';
        }
        return true;
    }

    private static int toInt2(String s, int start) {
        return (s.charAt(start) - 48) * 10 + (s.charAt(start + 1) - 48);
    }
}

