/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.io;

import com.pageseeder.common.UnforeseenException;
import com.pageseeder.common.io.Resource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;

public final class ResourceCompressor {
    private ResourceCompressor() {
    }

    public static PrintWriter compress(OutputStream out) {
        PrintWriter p;
        try {
            GZIPOutputStream compressor = new GZIPOutputStream(out);
            p = new PrintWriter(new OutputStreamWriter((OutputStream)compressor, StandardCharsets.UTF_8));
        }
        catch (IOException ex) {
            p = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        }
        return p;
    }

    public static boolean compress(Resource resource) {
        byte[] compressed;
        boolean ok = false;
        byte[] content = resource.getContent();
        if (content != null && (compressed = ResourceCompressor.compress(content)).length < content.length) {
            resource.setContent(compressed);
            ok = true;
        }
        return ok;
    }

    public static byte[] compress(byte[] content) {
        ByteArrayOutputStream os = new ByteArrayOutputStream(Math.max(content.length / 8, 512));
        try (GZIPOutputStream compressor = new GZIPOutputStream(os);){
            compressor.write(content);
        }
        catch (IOException ex) {
            throw new UnforeseenException(ex);
        }
        return os.toByteArray();
    }
}

