/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public final class AutoGzipByteArrayOutputStream
extends OutputStream {
    public static final int DEFAULT_GZIP_THRESHOLD = 1000;
    private final int threshold;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream(256);
    private OutputStream out = this.buffer;
    private int count = 0;
    private boolean isCompressed;

    public AutoGzipByteArrayOutputStream() {
        this.threshold = 1000;
    }

    public AutoGzipByteArrayOutputStream(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureCompression(this.count + 1);
        this.out.write(b);
        ++this.count;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException();
        }
        this.ensureCompression(this.count + len);
        this.out.write(b, off, len);
        this.count += len;
    }

    private void ensureCompression(int length) throws IOException {
        if (!this.isCompressed && this.threshold >= 0 && length > this.threshold) {
            byte[] initial = this.buffer.toByteArray();
            this.buffer = new ByteArrayOutputStream(256);
            this.out = new GZIPOutputStream(this.buffer);
            this.out.write(initial);
            this.isCompressed = true;
        }
    }

    public int getThreshold() {
        return this.threshold;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }

    public int size() {
        return this.buffer.size();
    }

    public int fullSize() {
        return this.count;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.out instanceof GZIPOutputStream) {
            ((GZIPOutputStream)this.out).finish();
        }
        this.out.close();
    }
}

