/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.http;

import com.pageseeder.common.http.EntityInfo;
import com.pageseeder.common.http.HttpAcceptHeader;
import com.pageseeder.common.http.HttpWebRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpRequests {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequests.class);
    private static final String GZIP_QUOTED_SUFFIX = "-gzip\"";
    private static final SimpleDateFormat HTTP_DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");

    private HttpRequests() {
    }

    public static boolean checkIfHeaders(HttpServletRequest request, HttpServletResponse response, EntityInfo info) {
        return HttpRequests.checkIfMatch(request, response, info) && HttpRequests.checkIfModifiedSince(request, response, info) && HttpRequests.checkIfNoneMatch(request, response, info) && HttpRequests.checkIfUnmodifiedSince(request, response, info);
    }

    private static boolean checkIfMatch(HttpServletRequest req, HttpServletResponse res, EntityInfo info) {
        String eTag = info.getETag();
        String headerValue = req.getHeader("If-Match");
        if (headerValue != null && headerValue.indexOf(42) == -1) {
            StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
            boolean conditionSatisfied = false;
            while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                Object currentToken = commaTokenizer.nextToken().trim();
                int gzip_length = 6;
                if (((String)currentToken).endsWith(GZIP_QUOTED_SUFFIX)) {
                    currentToken = ((String)currentToken).substring(0, ((String)currentToken).length() - 6) + "\"";
                }
                if (!((String)currentToken).equals(eTag)) continue;
                conditionSatisfied = true;
            }
            if (!conditionSatisfied) {
                HttpRequests.sendError(res, 412);
                return false;
            }
        }
        return true;
    }

    private static boolean checkIfModifiedSince(HttpServletRequest req, HttpServletResponse res, EntityInfo info) {
        try {
            long headerValue = req.getDateHeader("If-Modified-Since");
            long lastModified = info.getLastModified();
            if (headerValue != -1L && req.getHeader("If-None-Match") == null && lastModified < headerValue + 1000L) {
                res.setStatus(304);
                String etag = info.getETag();
                if (etag != null) {
                    if (HttpRequests.isCompressible(info.getMimeType()) && HttpRequests.acceptsGZipCompression(req)) {
                        etag = HttpRequests.getETagForGZip(etag);
                    }
                    res.setHeader("ETag", HttpRequests.toSafeHeader(etag));
                    LOGGER.debug("If-Modified-Since check: NOT MODIFIED, etag={}", (Object)etag);
                    return false;
                }
            }
        }
        catch (IllegalArgumentException ex) {
            return true;
        }
        return true;
    }

    private static boolean checkIfNoneMatch(HttpServletRequest req, HttpServletResponse res, EntityInfo info) {
        String etag = info.getETag();
        String headerValue = req.getHeader("If-None-Match");
        if (headerValue != null && etag != null) {
            boolean conditionSatisfied = false;
            boolean isGzip = false;
            if (!"*".equals(headerValue)) {
                StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
                while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                    Object currentToken = commaTokenizer.nextToken().trim();
                    isGzip = false;
                    if (((String)currentToken).endsWith(GZIP_QUOTED_SUFFIX)) {
                        int gzip_length = 6;
                        currentToken = ((String)currentToken).substring(0, ((String)currentToken).length() - 6) + "\"";
                        isGzip = true;
                    }
                    if (!((String)currentToken).equals(etag)) continue;
                    conditionSatisfied = true;
                }
            } else {
                conditionSatisfied = true;
            }
            if (conditionSatisfied) {
                if ("GET".equals(req.getMethod()) || "HEAD".equals(req.getMethod())) {
                    etag = isGzip ? HttpRequests.getETagForGZip(etag) : etag;
                    res.setStatus(304);
                    res.setHeader("ETag", HttpRequests.toSafeHeader(etag));
                    LOGGER.debug("If-None-Match check: match etag={}", (Object)etag);
                    return false;
                }
                LOGGER.debug("If-None-Match check: PRECONDITION FAILED, method={}", (Object)req.getMethod());
                HttpRequests.sendError(res, 412);
                return false;
            }
        }
        return true;
    }

    private static boolean checkIfUnmodifiedSince(HttpServletRequest req, HttpServletResponse res, EntityInfo info) {
        try {
            long lastModified = info.getLastModified();
            long headerValue = req.getDateHeader("If-Unmodified-Since");
            if (headerValue != -1L && lastModified >= headerValue + 1000L) {
                LOGGER.debug("If-None-Match check: PRECONDITION FAILED, last modified: {} >= {}", (Object)lastModified, (Object)headerValue);
                HttpRequests.sendError(res, 412);
                return false;
            }
        }
        catch (IllegalArgumentException ex) {
            return true;
        }
        return true;
    }

    public static boolean acceptsGZipCompression(HttpServletRequest req) {
        String encoding = req.getHeader("Accept-Encoding");
        return HttpAcceptHeader.accepts(encoding, "gzip");
    }

    public static void setContentLength(HttpServletResponse response, long contentLength) {
        if (contentLength < Integer.MAX_VALUE) {
            response.setContentLength((int)contentLength);
        } else {
            response.setHeader("Content-Length", "" + contentLength);
        }
    }

    public static boolean isCompressible(@Nullable String contentType) {
        if (contentType == null) {
            return false;
        }
        return contentType.startsWith("text") || contentType.endsWith("xml") || contentType.endsWith("json") || contentType.endsWith("javascript");
    }

    public static String getETagForGZip(String etag) {
        int q = etag.lastIndexOf("\"");
        return q > 0 ? etag.substring(0, q) + GZIP_QUOTED_SUFFIX : etag;
    }

    public static @Nullable String getETagForUncompressed(@Nullable String etag) {
        if (etag == null) {
            return null;
        }
        int q = etag.lastIndexOf(GZIP_QUOTED_SUFFIX);
        int gzip_length = 6;
        return q > 0 ? etag.substring(0, q - 6) + "\"" : etag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toLastModified(long modified) {
        SimpleDateFormat simpleDateFormat = HTTP_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return HTTP_DATE_FORMAT.format(new Date(modified));
        }
    }

    public static String toSafeHeader(String value) {
        return value.replaceAll("[\\r\\n]", " ");
    }

    public static long getLongHeader(HttpServletRequest req, String header) throws NumberFormatException {
        String value = req.getHeader(header);
        if (value == null) {
            return -1L;
        }
        return Long.parseLong(value);
    }

    public static void consumeInputStream(HttpServletRequest req) {
        try (ServletInputStream in = req.getInputStream();){
            in.transferTo(OutputStream.nullOutputStream());
        }
        catch (IOException ex) {
            LOGGER.debug("Failed to consume request input stream: {}", (Object)ex.getMessage());
        }
    }

    private static void sendError(HttpServletResponse res, int code) {
        if (res.isCommitted()) {
            HttpWebRequest.alreadyCommitted(code, "(default message)");
            return;
        }
        try {
            res.sendError(code);
        }
        catch (IOException io) {
            HttpWebRequest.swallow(io);
        }
    }

    static {
        HTTP_DATE_FORMAT.setTimeZone(GMT);
    }
}

