/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.http;

import com.pageseeder.common.http.EntityInfo;
import java.io.File;
import org.eclipse.jdt.annotation.Nullable;

public class FileEntityInfo
implements EntityInfo {
    private final File file;
    private final long modified;
    private final long length;
    private final String mime;

    public FileEntityInfo(File file, String mimeType) {
        boolean ok = file.exists();
        this.file = file;
        this.modified = ok ? file.lastModified() : -1L;
        this.length = ok ? file.length() : -1L;
        this.mime = mimeType;
    }

    @Override
    public final long getLastModified() {
        return this.modified;
    }

    public final long getContentLength() {
        return this.length;
    }

    @Override
    public final String getMimeType() {
        return this.mime;
    }

    @Override
    public final @Nullable String getETag() {
        if (this.length >= 0L || this.modified >= 0L) {
            return "W/\"" + this.length + "-" + this.modified + "\"";
        }
        return null;
    }

    public final File getFile() {
        return this.file;
    }
}

