/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.pdf.ant;

import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public final class ToImagesTask
extends Task {
    private File _source;
    private File _destination;
    private int _resolution = 300;
    private String _format = "png";

    public void setSrc(File pdf) {
        if (!pdf.exists()) {
            throw new BuildException("the PDF " + pdf.getName() + " doesn't exist");
        }
        if (pdf.isDirectory()) {
            throw new BuildException("the PDF " + pdf.getName() + " can't be a directory");
        }
        String name = pdf.getName();
        if (!name.endsWith(".pdf") && !name.endsWith(".pdf")) {
            this.log("presentation file should generally end with .pptx or .zip - but was " + name);
        }
        this._source = pdf;
    }

    public void setDest(File destination) {
        this._destination = destination;
        if (destination.exists() && !destination.isDirectory()) {
            throw new BuildException("the destination " + destination.getName() + " must be a directory");
        }
    }

    public void setResolution(int dpi) {
        this._resolution = dpi;
        if (dpi < 1) {
            throw new BuildException("The dpi " + dpi + " is too small (< 1)");
        }
        if (dpi < 72) {
            this.log("The dpi " + dpi + " might be too small (<72) and result in poor quality images.");
        } else if (dpi > 300) {
            this.log("The dpi " + dpi + " might be too large (>300) and result in slow processing.");
        } else if (dpi > 4000) {
            throw new BuildException("The dpi " + dpi + " is too large (> 4000)");
        }
    }

    public void setFormat(String format) {
        String[] supported;
        this._format = format;
        boolean isSupported = false;
        for (String s : supported = ImageIO.getReaderFormatNames()) {
            if (!s.equals(format)) continue;
            isSupported = true;
        }
        if (!isSupported) {
            throw new BuildException("The image format '" + format + "' is not supported, must be one of " + supported);
        }
    }

    public void execute() throws BuildException {
        if (this._source == null) {
            throw new BuildException("Source presentation must be specified using 'src' attribute");
        }
        if (this._destination == null) {
            this._destination = this._source.getParentFile();
            this.log("Destination set to source directory " + this._destination.getAbsolutePath() + "");
        }
        this.log("Processing " + this._source.getName());
        PDDocument document = null;
        try {
            document = PDDocument.load((File)this._source);
            String name = this._source.getName();
            if (name.endsWith(".pdf")) {
                name = name.substring(0, name.length() - 4);
            }
            this._destination.mkdirs();
            String prefix = new File(this._destination, name + "-p").getAbsolutePath();
            if (document.isEncrypted()) {
                throw new BuildException("The PDF document is encrypted");
            }
            int nbPages = document.getNumberOfPages();
            this.log("Found " + nbPages + " pages");
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            for (int i = 0; i < nbPages; ++i) {
                String fileName;
                BufferedImage bim = pdfRenderer.renderImageWithDPI(i, (float)this._resolution, ImageType.RGB);
                boolean ok = ImageIOUtil.writeImage((BufferedImage)bim, (String)((fileName = prefix + (i + 1)) + "." + this._format), (int)this._resolution);
                if (ok) continue;
                this.log("Unable to write page #" + (i + 1), 1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

