/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.furi;

import java.util.regex.Pattern;

public class VariableType {
    private static final Pattern VALID_NAME = Pattern.compile("[a-zA-Z0-9][\\w.-]*");
    private String _name;

    public VariableType(String name) {
        if (name == null) {
            throw new NullPointerException("A variable type must have a name, but was null");
        }
        if (!VariableType.isValidName(name)) {
            throw new IllegalArgumentException("The variable name is not valid: " + name);
        }
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        VariableType v = (VariableType)o;
        return this._name.equals(v._name);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public String toString() {
        return this._name;
    }

    protected static boolean isValidName(String name) {
        if (name == null) {
            return false;
        }
        return VALID_NAME.matcher(name).matches();
    }
}

