/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.web;

import com.pageseeder.base.logback.AccessEvent;
import com.pageseeder.base.logback.AccessLogger;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.model.URI;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebUtilities {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebUtilities.class);

    private WebUtilities() {
    }

    public static String getStackTrace(Throwable error, boolean safe) {
        int x;
        StringWriter sw = new StringWriter();
        error.printStackTrace(new PrintWriter(sw));
        StringBuffer stacktrace = sw.getBuffer();
        if (safe && (x = stacktrace.indexOf("javax.servlet.http.HttpServlet.service")) >= 0) {
            stacktrace.setLength(x);
            stacktrace.append("...");
        }
        return stacktrace.toString();
    }

    public static String getFrom(HttpServletRequest req) {
        String referer = Objects.toString(req.getHeader("Referer"), "");
        return !referer.isEmpty() ? referer : Objects.toString(req.getHeader("User-Agent"), "unknown");
    }

    public static boolean deprecatedError(HttpServletRequest req, @Nullable HttpServletResponse res, String description) {
        String strictString = GlobalSettings.getString((String)"serviceStrict", (String)"false");
        boolean strict = "true".equals(strictString);
        boolean log = strict || "log".equals(strictString);
        String referer = Objects.toString(req.getHeader("Referer"), "");
        if (res != null) {
            res.setHeader("Warning", WebUtilities.toWarningHeader("Deprecated API", strict, "6.2000"));
        }
        if (log) {
            String from = !referer.isEmpty() ? referer : Objects.toString(req.getHeader("User-Agent"), "unknown");
            LOGGER.warn("Request deprecated in {}: {} {} {} from {}", new Object[]{"6.2000", req.getMethod(), RuleUtils.removePasswordJsessionid(req.getRequestURI()), description, from});
        }
        if (strict) {
            if (res != null) {
                WebRequest wr = new WebRequest(req, res);
                wr.sendError(410, "This request is deprecated");
            }
            return true;
        }
        return false;
    }

    public static void logAccess(HttpServletRequest req, int status, String serviceId, long start, AccessEvent.Permission permission) {
        WebUtilities.logAccess(req, status, serviceId, start, permission, null, null);
    }

    public static void logAccess(HttpServletRequest req, int status, String serviceId, long start, AccessEvent.Permission permission, @Nullable Long groupId, @Nullable String groupName) {
        WebUtilities.logAccess(req, status, serviceId, start, permission, groupId, groupName, null);
    }

    public static void logAccess(HttpServletRequest req, int status, String serviceId, long start, AccessEvent.Permission permission, @Nullable Long groupId, @Nullable String groupName, @Nullable URI uri) {
        String username = SecurityUtils.getUsername(req);
        AccessEvent access = AccessEvent.newInstance(req, username);
        access.setComponent("service", serviceId);
        access.setGroup(groupId, groupName);
        access.setDocDetails(uri);
        access.setTime(System.currentTimeMillis() - start);
        access.setStatus(status);
        access.setPermission(permission);
        AccessLogger.track(access);
    }

    private static String toWarningHeader(String message, boolean strict, String version) {
        if (strict) {
            return String.format("299 - \"%1s\" \"%2s\"", message + " (strict)", version);
        }
        return String.format("299 - \"%1s\" \"%2s\"", message, version);
    }

    public static OutputType toOutputType(HttpServletRequest req) {
        String accept;
        String pathInfo = Objects.toString(req.getPathInfo(), "");
        int dot = pathInfo.lastIndexOf(46);
        if (dot != -1) {
            String ext = req.getPathInfo().substring(dot);
            if (".xml".equals(ext)) {
                return OutputType.XML;
            }
            if (".json".equals(ext)) {
                return OutputType.JSON;
            }
            if (".csv".equals(ext)) {
                return OutputType.CSV;
            }
        }
        if ("application/xml".equals(accept = req.getHeader("Accept"))) {
            return OutputType.XML;
        }
        if ("application/json".equals(accept)) {
            return OutputType.JSON;
        }
        if ("text/csv".equals(accept)) {
            return OutputType.CSV;
        }
        return OutputType.XML;
    }

    public static UniversalPrinter getUniversalPrinter(HttpServletRequest req, HttpServletResponse res) {
        try {
            OutputType type = WebUtilities.toOutputType(req);
            res.setContentType(type.getMediaType());
            res.setCharacterEncoding("utf-8");
            return UniversalPrinter.newWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), StandardCharsets.UTF_8), type);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

