/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.util;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XMLParserErrorHandler
implements ErrorHandler {
    private final List<String> errors = new ArrayList<String>();
    private final List<String> warnings = new ArrayList<String>();

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.errors.add("ERROR: " + this.toMessage(exception));
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.errors.add("FATAL: " + this.toMessage(exception));
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.warnings.add("WARNING: " + this.toMessage(exception));
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public List<String> getErrors() {
        return this.errors;
    }

    private String toMessage(SAXParseException exception) {
        return exception.getMessage() + " [" + exception.getLineNumber() + ":" + exception.getColumnNumber() + "]";
    }
}

