/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.url;

import com.pageseeder.base.label.LabelInfo;
import com.pageseeder.base.url.URLConfig;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class URLConfigHandler
extends DefaultHandler {
    private boolean inCreation = false;
    private boolean inLabeling = false;
    private boolean inPublishing = false;
    private boolean loadLabels = false;
    private @Nullable URLConfig.PublishAction action = null;
    private @Nullable String currentTarget = null;
    private @Nullable String currentParam = null;
    private final URLConfig config;
    private @Nullable StringBuilder text = null;

    protected URLConfigHandler(String owner, String type, @Nullable List<LabelInfo> projectLabels) {
        this.config = new URLConfig(owner, type);
        this.config.addLabels(projectLabels);
    }

    public URLConfig getConfig() {
        return this.config;
    }

    @Override
    public void startDocument() {
        this.config.setTitle(null);
        this.config.clearDomains();
        this.config.clearMediatypes();
    }

    @Override
    public void startElement(String uri, @Nullable String localName, String qName, Attributes attributes) throws SAXException {
        String element;
        String string = element = localName == null ? qName : localName;
        if ("creation".equals(element) && !"true".equals(attributes.getValue("disabled"))) {
            this.inCreation = true;
        } else if ("title".equals(element) && this.inCreation) {
            this.text = new StringBuilder();
        } else if ("domain".equals(element) && this.inCreation) {
            this.config.addDomain(attributes.getValue("name"));
        } else if ("media".equals(element) && this.inCreation) {
            this.config.addMediatype(attributes.getValue("type"));
        } else if ("labeling".equals(element)) {
            this.inLabeling = true;
            if ("true".equals(attributes.getValue("override"))) {
                this.config.clearLabels();
            }
        } else if ("labels".equals(element) && this.inLabeling) {
            this.loadLabels = "url".equals(attributes.getValue("type"));
        } else if ("label".equals(element) && this.loadLabels) {
            String name = attributes.getValue("name");
            String description = attributes.getValue("description");
            String color = attributes.getValue("color");
            LabelInfo label = new LabelInfo(name, description, null);
            label.setColor(color);
            this.config.addLabel(label);
        } else if ("publishing".equals(element)) {
            this.inPublishing = true;
            if ("true".equals(attributes.getValue("override"))) {
                this.config.clearActions();
            }
        } else if ("action".equals(element) && this.inPublishing) {
            this.action = new URLConfig.PublishAction(attributes.getValue("type"), this.config.getURLType());
        } else if ("target".equals(element) && this.action != null) {
            this.currentTarget = attributes.getValue("name");
            this.action.addTarget(this.currentTarget, attributes);
        } else if ("description".equals(element) && this.currentTarget != null) {
            this.text = new StringBuilder();
        } else if ("param".equals(element) && this.action != null && this.currentTarget != null) {
            this.action.addTargetParam(this.currentTarget, attributes);
            this.currentParam = attributes.getValue("name");
        } else if ("autosuggest".equals(element) && this.action != null && this.currentParam != null) {
            this.action.setParamAutosuggest(this.currentParam, attributes);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.text != null) {
            this.text.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, @Nullable String localName, String qName) throws SAXException {
        String element;
        String string = element = localName == null ? qName : localName;
        if ("creation".equals(element)) {
            this.inCreation = false;
        } else if ("title".equals(element) && this.text != null) {
            this.config.setTitle(this.text.toString());
            this.text = null;
        } else if ("labeling".equals(element)) {
            this.inLabeling = false;
        } else if ("labels".equals(element)) {
            this.loadLabels = false;
        } else if ("publishing".equals(element)) {
            this.inPublishing = false;
        } else if ("action".equals(element) && this.inPublishing) {
            this.config.addPublishAction(this.action);
            this.action = null;
        } else if ("target".equals(element)) {
            this.currentTarget = null;
        } else if ("param".equals(element)) {
            this.currentParam = null;
        } else if ("description".equals(element) && this.action != null && this.currentTarget != null) {
            if (this.text != null) {
                this.action.addTargetDescription(this.currentTarget, this.text.toString());
            }
            this.text = null;
        }
    }
}

