/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.thread;

import com.pageseeder.base.thread.ProcessLogger;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.common.util.MD5;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessManager.class);
    private final ProcessLogger processLogger;
    private static final int THREAD_PRIORITY = Math.round(4.0f);
    private final Map<String, ProcessThread> threadsList = new ConcurrentHashMap<String, ProcessThread>();
    private final Map<Long, Collection<String>> threadsPerGroup = new ConcurrentHashMap<Long, Collection<String>>();
    private final ExecutorService threadPool;
    private final AtomicInteger threadCounter = new AtomicInteger(0);
    private @Nullable CleanUpThread cleanupThread;

    private ProcessManager() {
        this.threadPool = Executors.newCachedThreadPool(r -> {
            Thread t = new Thread(r, "ps-process-p" + THREAD_PRIORITY);
            t.setPriority(THREAD_PRIORITY);
            return t;
        });
        try {
            this.processLogger = new ProcessLogger();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to create PSThread Logger: " + ex.getMessage());
        }
        this.cleanupThread = new CleanUpThread();
        this.threadPool.execute(this.cleanupThread);
    }

    public static ProcessManager getInstance() {
        return Holder.INSTANCE;
    }

    public ProcessLogger getLogger() {
        return this.processLogger;
    }

    public void start(ProcessThread thread) {
        this.prepareForStart(thread, false);
        this.execute(thread, true);
    }

    public void prepareForStart(ProcessThread thread, boolean logStartEvent) {
        String threadId = MD5.hash((String)(System.currentTimeMillis() + "-" + this.threadCounter.getAndIncrement()));
        thread.setIDAndLogger(threadId, this.processLogger);
        threadId = thread.getThreadID();
        assert (threadId != null);
        this.threadsList.put(threadId, thread);
        Collection forGroup = this.threadsPerGroup.computeIfAbsent(thread.getGroupID(), k -> new ConcurrentLinkedQueue());
        if (!forGroup.contains(threadId)) {
            forGroup.add(threadId);
        }
        if (logStartEvent) {
            this.processLogger.startThread(thread);
        }
    }

    public void execute(ProcessThread thread, boolean logStartEvent) {
        String threadId = thread.getThreadID();
        this.threadsList.put(threadId, thread);
        Collection forGroup = this.threadsPerGroup.computeIfAbsent(thread.getGroupID(), k -> new ConcurrentLinkedQueue());
        if (!forGroup.contains(threadId)) {
            forGroup.add(threadId);
        }
        if (logStartEvent) {
            this.processLogger.startThread(thread);
        }
        this.threadPool.execute(thread);
    }

    public void clearIfFinished(String threadId) {
        ProcessThread thread = this.threadsList.get(threadId);
        if (thread != null && thread.isFinished()) {
            Collection<String> ids = this.threadsPerGroup.get(thread.getGroupID());
            ids.remove(thread.getThreadID());
            this.threadsList.remove(thread.getThreadID());
        }
    }

    public void cancel(String id) {
        ProcessThread t = this.threadsList.get(id);
        if (t != null) {
            t.cancel();
        }
    }

    public void outputAllThreads(XMLWriter xml) throws IOException {
        xml.openElement("threads");
        for (ProcessThread t : this.threadsList.values()) {
            if (t == null) continue;
            t.toXML(xml);
        }
        xml.closeElement();
    }

    public void outputThreadsForGroup(@Nullable Long groupId, XMLWriter xml) throws IOException {
        if (groupId == null) {
            this.outputAllThreads(xml);
            return;
        }
        xml.openElement("threads");
        Collection<String> ids = this.threadsPerGroup.get(groupId);
        if (ids != null) {
            for (String id : ids) {
                if (!this.threadsList.containsKey(id)) continue;
                this.threadsList.get(id).toXML(xml);
            }
        }
        xml.closeElement();
    }

    public Set<String> getThreadIDs() {
        return Collections.unmodifiableSet(this.threadsList.keySet());
    }

    public @Nullable ProcessThread getThread(String id) {
        return this.threadsList.get(id);
    }

    public void shutdown() {
        boolean done;
        this.threadPool.shutdown();
        if (this.cleanupThread != null) {
            this.cleanupThread.stop();
            this.cleanupThread = null;
        }
        if (!this.threadsList.isEmpty() && !(done = this.awaitThreadPoolTermination("before"))) {
            this.cancelAllThreads();
            done = this.awaitThreadPoolTermination("after");
            if (!done) {
                LOGGER.warn("Failed to shutdown all threads");
            }
        }
    }

    private boolean awaitThreadPoolTermination(String when) {
        try {
            return this.threadPool.awaitTermination("before".equals(when) ? 5L : 60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Shutdown interrupted {} cancelling all threads", (Object)when, (Object)ex);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private void cancelAllThreads() {
        LOGGER.info("Cancelling {} process threads", (Object)this.threadsList.size());
        for (ProcessThread thread : new ArrayList<ProcessThread>(this.threadsList.values())) {
            try {
                thread.cancel();
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to cancel thread: {}", (Object)thread.getThreadID(), (Object)ex);
            }
        }
    }

    public final class CleanUpThread
    implements Runnable {
        private static final long DELAY_MS = 5000L;
        private static final long TIMEOUT_MS = 61000L;
        private volatile boolean shouldStop = false;

        @Override
        public void run() {
            while (!this.shouldStop) {
                try {
                    Thread.sleep(5000L);
                    this.cleanUpStaleThreads();
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Clean up thread interrupted");
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }

        private void cleanUpStaleThreads() {
            long now = System.currentTimeMillis();
            for (ProcessThread th : ProcessManager.this.threadsList.values()) {
                String id;
                if (now - th.getLastUpdated() <= 61000L || (id = th.getThreadID()) == null) continue;
                ProcessManager.this.clearIfFinished(id);
            }
        }

        public void stop() {
            this.shouldStop = true;
        }
    }

    private static class Holder {
        private static final ProcessManager INSTANCE = new ProcessManager();

        private Holder() {
        }
    }
}

