/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.serial;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.PrintException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterImpl;

public class XMLOutputPrinter
extends OutputPrinter {
    private final Writer out;
    private final XMLWriter xml;
    private final Deque<OutputPrinter.ContextOption> ignore = new ArrayDeque<OutputPrinter.ContextOption>();

    public XMLOutputPrinter() {
        this(new StringWriter());
    }

    public XMLOutputPrinter(Writer out) {
        this.out = out;
        this.xml = new XMLWriterImpl(out);
    }

    public XMLOutputPrinter(XMLWriter xml, Writer out) {
        this.out = out;
        this.xml = xml;
    }

    public XMLOutputPrinter(XMLWriter xml) {
        this.out = new NOPWriter();
        this.xml = xml;
    }

    @Override
    public final OutputType getType() {
        return OutputType.XML;
    }

    @Override
    public final void field(String name, boolean value, OutputPrinter.FieldOption option) {
        this.field(name, Boolean.toString(value), option);
    }

    @Override
    public final void field(String name, long value, OutputPrinter.FieldOption option) {
        this.field(name, Long.toString(value), option);
    }

    @Override
    public void field(String name, String[] values, OutputPrinter.FieldOption option) {
        this.field(name, String.join((CharSequence)",", values), option);
    }

    @Override
    public final void field(String name, String value, OutputPrinter.FieldOption option) {
        try {
            switch (option) {
                case XML_TEXT: {
                    this.xml.writeText(value);
                    return;
                }
                case XML_ELEMENT: {
                    this.xml.element(name, value);
                    return;
                }
                case XML_COPY: {
                    this.xml.writeXML(value);
                    return;
                }
                case JSON_ONLY: 
                case CSV_ONLY: {
                    return;
                }
            }
            this.xml.attribute(name, value);
        }
        catch (IOException ex) {
            throw new PrintException("Unable to write field", ex);
        }
    }

    @Override
    public final void startObject(String name, OutputPrinter.ObjectOption option) {
        this.ignore.push(option);
        try {
            this.xml.openElement(name, option != OutputPrinter.ObjectOption.XML_EMPTY);
        }
        catch (IOException ex) {
            throw new PrintException("Unable to open element", ex);
        }
    }

    @Override
    public final void endObject() {
        this.ignore.pop();
        try {
            this.xml.closeElement();
        }
        catch (IOException ex) {
            throw new PrintException("Unable to close element", ex);
        }
    }

    @Override
    public final void startCollection(String name, OutputPrinter.CollectionOption option) {
        this.ignore.push(option);
        if (option != OutputPrinter.CollectionOption.JSON_ONLY) {
            try {
                this.xml.openElement(name, option != OutputPrinter.CollectionOption.XML_EMPTY);
            }
            catch (IOException ex) {
                throw new PrintException("Unable to open collection element for collection", ex);
            }
        }
    }

    @Override
    public final void endCollection() {
        OutputPrinter.ContextOption option = this.ignore.pop();
        if (option != OutputPrinter.CollectionOption.JSON_ONLY) {
            try {
                this.xml.closeElement();
            }
            catch (IOException ex) {
                throw new PrintException("Unable to close element for collection", ex);
            }
        }
    }

    @Override
    public final void flush() {
        try {
            this.xml.flush();
        }
        catch (IOException ex) {
            throw new PrintException("Unable to flush XML writer", ex);
        }
    }

    @Override
    public void close() {
        try {
            this.xml.close();
        }
        catch (IOException ex) {
            throw new PrintException("Unable to close XML writer", ex);
        }
    }

    public String toString() {
        this.flush();
        if (this.out instanceof StringWriter) {
            return this.out.toString();
        }
        if (this.xml instanceof XMLStringWriter) {
            return this.xml.toString();
        }
        return super.toString();
    }

    private static class NOPWriter
    extends Writer {
        private NOPWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

