/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.security;

import com.pageseeder.common.UnforeseenException;
import com.pageseeder.common.util.Base64;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public abstract class PasswordFormat {
    protected final int saltLengthInBytes;
    private final boolean useBase64Url;

    PasswordFormat(int saltLength, boolean useBase64Url) {
        this.saltLengthInBytes = saltLength;
        this.useBase64Url = useBase64Url;
    }

    public final String encode(String password) {
        byte[] salt = this.generateSalt();
        return this.format(salt, this.generateHash(password, salt));
    }

    abstract boolean check(String var1, String var2);

    abstract byte[] generateHash(String var1, byte[] var2);

    abstract String format(byte[] var1, byte[] var2);

    public String generateHash(String password, String salt) {
        return this.asString(this.generateHash(password, this.asBytes(salt)));
    }

    protected byte[] asBytes(String s) {
        return this.useBase64Url ? Base64.decodeURL((char[])s.toCharArray()) : Base64.decode((char[])s.toCharArray());
    }

    protected String asString(byte[] bytes) {
        return new String(this.useBase64Url ? Base64.encodeURL((byte[])bytes) : Base64.encode((byte[])bytes));
    }

    protected byte[] generateSalt() {
        try {
            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
            byte[] salt = new byte[this.saltLengthInBytes];
            sr.nextBytes(salt);
            return salt;
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnforeseenException((Throwable)e);
        }
    }

    public static class NilPassword
    extends PasswordFormat {
        NilPassword() {
            super(0, false);
        }

        @Override
        boolean check(String enteredPassword, String storedPassword) {
            return false;
        }

        @Override
        byte[] generateHash(String password, byte[] salt) {
            return new byte[0];
        }

        @Override
        String format(byte[] salt, byte[] hash) {
            return "";
        }
    }
}

