/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.security;

import com.pageseeder.base.security.EncryptionException;
import com.pageseeder.base.security.KeyStorage;
import com.pageseeder.base.security.KeyStorageException;
import com.pageseeder.common.util.BinaryFormat;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GCM {
    private static final String AES_GCM_CIPHER = "AES/GCM/NoPadding";
    private static final int GCM_NONCE_LENGTH = 12;
    private static final int GCM_TAG_LENGTH = 16;
    private static final Logger LOGGER;
    private static final Random SR;

    private GCM() {
    }

    public static byte[] encrypt(String keyAlias, byte[] data) throws KeyStorageException, EncryptionException {
        SecretKey key = GCM.getKey(keyAlias);
        return GCM.doEncrypt(key, data, null);
    }

    public static byte @Nullable [] encryptSilently(String keyAlias, byte[] data) {
        SecretKey key = GCM.getKeySilently(keyAlias);
        return GCM.doEncryptSilently(key, data, null);
    }

    public static byte[] encrypt(String keyAlias, String data) throws KeyStorageException, EncryptionException {
        SecretKey key = GCM.getKey(keyAlias);
        return GCM.doEncrypt(key, data, null);
    }

    public static byte @Nullable [] encryptSilently(String keyAlias, String data) {
        SecretKey key = GCM.getKeySilently(keyAlias);
        return GCM.doEncryptSilently(key, data.getBytes(StandardCharsets.UTF_8), null);
    }

    public static String encrypt(String keyAlias, String message, BinaryFormat format) throws KeyStorageException, EncryptionException {
        SecretKey key = GCM.getKey(keyAlias);
        byte[] encrypted = GCM.doEncrypt(key, message, null);
        return format.encode(encrypted);
    }

    public static @Nullable String encryptSilently(String keyAlias, String message, BinaryFormat format) {
        SecretKey key = GCM.getKeySilently(keyAlias);
        byte[] encrypted = GCM.doEncryptSilently(key, message.getBytes(StandardCharsets.UTF_8), null);
        return encrypted != null ? format.encode(encrypted) : null;
    }

    public static String encrypt(String keyAlias, String message, String authenticated, BinaryFormat format) throws KeyStorageException, EncryptionException {
        SecretKey key = GCM.getKey(keyAlias);
        byte[] encrypted = GCM.doEncrypt(key, message, authenticated);
        return format.encode(encrypted);
    }

    public static @Nullable String encryptSilently(String keyAlias, String message, String authenticated, BinaryFormat format) {
        SecretKey key = GCM.getKeySilently(keyAlias);
        byte[] encrypted = GCM.doEncryptSilently(key, message.getBytes(StandardCharsets.UTF_8), authenticated);
        return encrypted != null ? format.encode(encrypted) : null;
    }

    public static byte[] decryptData(String keyAlias, byte[] data) throws KeyStorageException, EncryptionException {
        SecretKey key = GCM.getKey(keyAlias);
        return GCM.doDecrypt(key, data, null);
    }

    public static byte @Nullable [] decryptDataSilently(String keyAlias, byte[] bytes) {
        SecretKey key = GCM.getKeySilently(keyAlias);
        return GCM.doDecryptSilently(key, bytes, null);
    }

    public static String decrypt(String keyAlias, byte[] bytes) throws KeyStorageException, EncryptionException {
        SecretKey key = GCM.getKey(keyAlias);
        return GCM.doDecryptString(key, bytes, null);
    }

    public static @Nullable String decryptSilently(String keyAlias, byte[] bytes) {
        SecretKey key = GCM.getKeySilently(keyAlias);
        return GCM.doDecryptStringSilently(key, bytes, null);
    }

    public static String decrypt(String keyAlias, String message, BinaryFormat format) throws KeyStorageException, EncryptionException {
        SecretKey key = GCM.getKey(keyAlias);
        try {
            byte[] bytes = format.decode(message);
            return GCM.doDecryptString(key, bytes, null);
        }
        catch (IllegalArgumentException ex) {
            throw new EncryptionException("Message not matching binary format: " + message);
        }
    }

    public static @Nullable String decryptSilently(String keyAlias, String message, BinaryFormat format) {
        SecretKey key = GCM.getKeySilently(keyAlias);
        try {
            byte[] bytes = format.decode(message);
            return GCM.doDecryptStringSilently(key, bytes, null);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static String decrypt(String keyAlias, String message, String authenticated, BinaryFormat format) throws KeyStorageException, EncryptionException {
        SecretKey key = GCM.getKey(keyAlias);
        try {
            byte[] bytes = format.decode(message);
            return GCM.doDecryptString(key, bytes, authenticated);
        }
        catch (IllegalArgumentException ex) {
            throw new EncryptionException("Message not matching binary format: " + message);
        }
    }

    public static @Nullable String decryptSilently(String keyAlias, String message, String authenticated, BinaryFormat format) {
        SecretKey key = GCM.getKeySilently(keyAlias);
        try {
            byte[] bytes = format.decode(message);
            return GCM.doDecryptStringSilently(key, bytes, authenticated);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    private static SecretKey getKey(String keyAlias) throws KeyStorageException {
        return KeyStorage.getInstance().getSecretKey(keyAlias, KeyStorage.KeyType.AES);
    }

    private static @Nullable SecretKey getKeySilently(String keyAlias) {
        return KeyStorage.getInstance().getSecretKeySilently(keyAlias, KeyStorage.KeyType.AES);
    }

    private static byte[] doEncrypt(SecretKey key, String message, @Nullable String authenticated) throws EncryptionException {
        return GCM.doEncrypt(key, message.getBytes(StandardCharsets.UTF_8), authenticated);
    }

    private static byte[] doEncrypt(SecretKey key, byte[] data, @Nullable String authenticated) throws EncryptionException {
        try {
            Cipher cipher = Cipher.getInstance(AES_GCM_CIPHER);
            byte[] nonce = GCM.newNonce();
            GCMParameterSpec spec = new GCMParameterSpec(128, nonce);
            cipher.init(1, (Key)key, spec);
            if (authenticated != null) {
                byte[] aad = authenticated.getBytes();
                cipher.updateAAD(aad);
            }
            byte[] cipherText = cipher.doFinal(data);
            return GCM.merge(nonce, cipherText);
        }
        catch (GeneralSecurityException ex) {
            throw new EncryptionException("Unable to encrypt message", ex);
        }
    }

    private static byte @Nullable [] doEncryptSilently(@Nullable SecretKey key, byte[] data, @Nullable String authenticated) {
        if (key == null) {
            return null;
        }
        try {
            return GCM.doEncrypt(key, data, authenticated);
        }
        catch (GeneralSecurityException ex) {
            LOGGER.warn("Unable to encrypt message: {}", (Object)ex.getMessage());
            return null;
        }
    }

    private static byte[] doDecrypt(SecretKey key, byte[] message, @Nullable String authenticated) throws EncryptionException {
        try {
            if (message.length <= 12) {
                throw new EncryptionException("Message too short, missing nonce: " + message.length + " bytes");
            }
            byte[] nonce = Arrays.copyOf(message, 12);
            byte[] cipherText = Arrays.copyOfRange(message, 12, message.length);
            Cipher cipher = Cipher.getInstance(AES_GCM_CIPHER);
            GCMParameterSpec spec = new GCMParameterSpec(128, nonce);
            cipher.init(2, (Key)key, spec);
            if (authenticated != null) {
                byte[] aad = authenticated.getBytes();
                cipher.updateAAD(aad);
            }
            return cipher.doFinal(cipherText);
        }
        catch (IllegalArgumentException | GeneralSecurityException ex) {
            throw new EncryptionException("Unable to decrypt message", ex);
        }
    }

    private static byte @Nullable [] doDecryptSilently(@Nullable SecretKey key, byte[] message, @Nullable String authenticated) {
        if (key == null) {
            return null;
        }
        try {
            if (message.length <= 12) {
                return null;
            }
            return GCM.doDecrypt(key, message, authenticated);
        }
        catch (GeneralSecurityException ex) {
            LOGGER.warn(ex.getMessage());
            return null;
        }
    }

    private static String doDecryptString(SecretKey key, byte[] message, @Nullable String authenticated) throws EncryptionException {
        byte[] raw = GCM.doDecrypt(key, message, authenticated);
        return new String(raw, StandardCharsets.UTF_8);
    }

    private static @Nullable String doDecryptStringSilently(@Nullable SecretKey key, byte[] message, @Nullable String authenticated) {
        byte[] raw = GCM.doDecryptSilently(key, message, authenticated);
        return raw != null ? new String(raw, StandardCharsets.UTF_8) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] newNonce() {
        byte[] nonce = new byte[12];
        Random random = SR;
        synchronized (random) {
            SR.nextBytes(nonce);
        }
        return nonce;
    }

    private static byte[] merge(byte[] a, byte[] b) {
        byte[] merge = Arrays.copyOf(a, a.length + b.length);
        System.arraycopy(b, 0, merge, a.length, b.length);
        return merge;
    }

    static {
        SecureRandom random;
        LOGGER = LoggerFactory.getLogger(GCM.class);
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
            ((Random)random).setSeed(System.nanoTime());
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.error("Reverting to default secure random generator due to {}", (Object)ex.getMessage(), (Object)ex);
            random = new SecureRandom();
        }
        SR = random;
    }
}

