/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.security;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.rule.HostRule;
import com.pageseeder.base.security.AntiCSRFToken;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.common.net.URLs;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Host;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jdt.annotation.Nullable;

public final class CSRF {
    public static final int CSRF_HTTP_CODE = 419;
    public static final String CSRF_ERROR_MESSAGE = "Missing correct CSRF token";
    private static final String ANTI_CSRF_TOKEN = "anti-csrf-token";
    public static final ErrorID FAILED_CSRF = new ErrorID(){

        @Override
        public int id() {
            return 267;
        }

        @Override
        public String message() {
            return CSRF.CSRF_ERROR_MESSAGE;
        }
    };

    private CSRF() {
    }

    public static String attachAntiCSRFToken(HttpSession session) {
        String token = AntiCSRFToken.generateToken(session.getId());
        session.setAttribute(ANTI_CSRF_TOKEN, (Object)token);
        return token;
    }

    public static @Nullable String getAntiCSRFToken(@Nullable HttpSession session) {
        if (session == null) {
            return null;
        }
        String token = (String)session.getAttribute(ANTI_CSRF_TOKEN);
        if (token == null) {
            token = CSRF.attachAntiCSRFToken(session);
        }
        return token;
    }

    public static boolean validateAntiCSRFToken(HttpServletRequest req) {
        String from;
        String method = req.getMethod();
        HttpSession session = req.getSession(false);
        String m = GlobalSettings.getString((String)"csrfMode", (String)"partial-log");
        boolean log = m.endsWith("-log");
        CSRFMode mode = CSRFMode.fromString(m);
        if (req.getAttribute("csrf-origin-referer-valid") == Boolean.TRUE) {
            return true;
        }
        if (session == null) {
            return true;
        }
        if (SecurityUtils.getSessionMemberId(session) == null) {
            return true;
        }
        if (!("POST".equals(method) || "PUT".equals(method) || "DELETE".equals(method) || "PATCH".equals(method))) {
            return true;
        }
        String token = req.getHeader("Anti-CSRF-Token");
        if (token == null) {
            token = req.getParameter(ANTI_CSRF_TOKEN);
        }
        boolean res = mode == CSRFMode.DISABLE;
        String referer = req.getHeader("Referer");
        String origin = req.getHeader("Origin");
        String userAgent = req.getHeader("User-Agent");
        if (mode == CSRFMode.PARTIAL && origin == null && referer == null && userAgent != null && userAgent.startsWith("Bridge/")) {
            res = true;
        }
        String cleanUrl = RuleUtils.removePasswordJsessionid(req.getRequestURI());
        String string = from = !Strings.isEmpty((String)referer) ? referer : Objects.toString(userAgent, "unknown");
        if (token == null) {
            if (log) {
                SecurityLog.warn(SecurityLog.EventType.CSRF, "Request missing anti-CSRF token in {} {} from {}", method, cleanUrl, from);
            }
            return res;
        }
        String sessionId = session.getId();
        AntiCSRFToken t = AntiCSRFToken.parse(token);
        if (t == null) {
            if (log) {
                SecurityLog.warn(SecurityLog.EventType.CSRF, "Invalid anti-CSRF token in {} {} from {}", method, cleanUrl, from);
            }
            return res;
        }
        if (!t.sessionId().equals(sessionId)) {
            Object fromURL = origin != null ? origin + "/" : referer;
            String hostURL = URLs.asString((String)Settings.getServerScheme(), (String)Settings.getServerHost(), (int)Settings.getServerPort(), null);
            if (log && (fromURL == null || !((String)fromURL).startsWith(hostURL))) {
                SecurityLog.warn(SecurityLog.EventType.CSRF, "Anti-CSRF token does not match session ID in {} {} from {}", method, cleanUrl, from);
            }
            return res;
        }
        return true;
    }

    public static boolean validateOriginReferer(HttpServletRequest req, Database db) {
        URL url;
        boolean res;
        String method = req.getMethod();
        String m = GlobalSettings.getString((String)"csrfMode", (String)"partial-log");
        boolean log = m.endsWith("-log");
        CSRFMode mode = CSRFMode.fromString(m);
        if (!("POST".equals(method) || "PUT".equals(method) || "DELETE".equals(method) || "PATCH".equals(method))) {
            return true;
        }
        String origin = req.getHeader("Origin");
        String referer = req.getHeader("Referer");
        if (origin == null && referer == null) {
            return true;
        }
        boolean bl = res = mode == CSRFMode.DISABLE;
        if (mode == CSRFMode.PARTIAL && req.getHeader("Origin") == null && req.getHeader("Referer") == null && req.getHeader("User-Agent") != null && req.getHeader("User-Agent").startsWith("Bridge/")) {
            res = true;
        }
        try {
            url = origin != null ? new URL(origin) : new URL(referer);
        }
        catch (MalformedURLException ex) {
            if (log) {
                SecurityLog.error(SecurityLog.EventType.CSRF, "CSRF Origin/Referer header check failed for Origin: {}, Referer: {}", origin, referer);
            }
            return res;
        }
        String urlHost = url.getHost();
        if (GlobalSettings.getString((String)"webSiteAddress", (String)"").equalsIgnoreCase(urlHost)) {
            req.setAttribute("csrf-origin-referer-valid", (Object)Boolean.TRUE);
            return true;
        }
        try {
            urlHost = HostRule.resolveAlias(db, urlHost);
            Host host = DatabaseQuery.getHostByName((Database)db, (String)urlHost);
            if (host == null || host.isExternal()) {
                if (log) {
                    SecurityLog.warn(SecurityLog.EventType.CSRF, "CSRF Origin/Referer header invalid for {}", urlHost);
                }
                return res;
            }
            req.setAttribute("csrf-origin-referer-valid", (Object)Boolean.TRUE);
            return true;
        }
        catch (QueryFailedException ex) {
            if (log) {
                SecurityLog.error(SecurityLog.EventType.CSRF, "CSRF Origin/Referer header check failed for {}: {}", urlHost, ex.getMessage());
            }
            return res;
        }
    }

    public static enum CSRFMode {
        ENFORCE,
        PARTIAL,
        DISABLE;


        public static CSRFMode fromString(String s) {
            if (s.contains("-")) {
                s = s.substring(0, s.indexOf(45));
            }
            for (CSRFMode v : CSRFMode.values()) {
                if (!v.name().toLowerCase().equals(s)) continue;
                return v;
            }
            return PARTIAL;
        }
    }
}

