/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.security;

import com.pageseeder.base.cache.SafeCacheWrapper;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.oauth.Client;
import com.pageseeder.db.oauth.OAuthQuery;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import net.sf.ehcache.Element;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CORS {
    private static final Logger LOGGER = LoggerFactory.getLogger(CORS.class);
    private static final SafeCacheWrapper<Origin, Boolean> CACHE_ORIGINS = SafeCacheWrapper.getInstance("client-origins");

    private CORS() {
    }

    public static boolean isAcceptableOrigin(String header, Database db) throws DatabaseException {
        Origin origin = CORS.toOrigin(header);
        boolean isAcceptable = false;
        if (origin != Origin.INVALID) {
            Element element = CACHE_ORIGINS.getElement(origin);
            if (element != null && !element.isExpired()) {
                isAcceptable = (Boolean)element.getObjectValue();
            } else {
                isAcceptable = CORS.lookupOrigin(origin, db);
                CORS.cache(origin, isAcceptable);
            }
        }
        LOGGER.debug("Checking CORS Origin `{}` => {}", (Object)origin, (Object)isAcceptable);
        return isAcceptable;
    }

    private static synchronized boolean lookupOrigin(Origin origin, Database db) throws QueryFailedException {
        if (origin == Origin.INVALID) {
            return false;
        }
        LOGGER.debug("Looking up client origin `{}` in database", (Object)origin);
        List clients = OAuthQuery.listClientsByClientURIStartsWith((Database)db, (String)origin.toString());
        for (Client client : clients) {
            if (!origin.equals(CORS.toOrigin(client.getClientURI()))) continue;
            return true;
        }
        return false;
    }

    public static void addOrigin(@Nullable String clientURI) {
        CORS.cache(CORS.toOrigin(clientURI), true);
    }

    public static void removeOrigin(@Nullable String clientURI) {
        Origin origin = CORS.toOrigin(clientURI);
        if (origin != Origin.INVALID) {
            CACHE_ORIGINS.remove(origin);
        }
    }

    private static void cache(Origin origin, boolean acceptable) {
        if (origin != Origin.INVALID) {
            Element element = new Element((Serializable)origin, (Serializable)Boolean.valueOf(acceptable));
            if (acceptable) {
                element.setEternal(true);
            } else {
                element.setTimeToIdle(60);
                element.setTimeToLive(86400);
            }
            CACHE_ORIGINS.putElement(element);
        }
    }

    private static Origin toOrigin(@Nullable String clientURI) {
        if (clientURI == null || !clientURI.startsWith("http")) {
            return Origin.INVALID;
        }
        try {
            URI uri = new URI(clientURI);
            return Origin.origin("https".equals(uri.getScheme()), uri.getHost(), uri.getPort());
        }
        catch (URISyntaxException ex) {
            return Origin.INVALID;
        }
    }

    private static class Origin
    implements Serializable {
        private static final Origin INVALID = new Origin("//invalid");
        private final String url;

        private Origin(String origin) {
            this.url = origin;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Origin origin = (Origin)o;
            return this.url.equals(origin.url);
        }

        public int hashCode() {
            return this.url.hashCode();
        }

        public String toString() {
            return this.url;
        }

        private static Origin origin(boolean secure, String host, int port) {
            boolean hasDefaultPort;
            boolean bl = hasDefaultPort = port == -1 || secure && port == 443 || !secure && port == 80;
            if (hasDefaultPort) {
                return new Origin((secure ? "https://" : "http://") + host);
            }
            return new Origin((secure ? "https://" : "http://") + host + ":" + port);
        }
    }
}

