/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.security;

import com.pageseeder.base.security.PasswordFormat;
import com.pageseeder.base.security.PasswordFormatException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;

public final class ArgonPassword
extends PasswordFormat {
    private static final int[][] PRESETS = new int[][]{{1, 3}, {1, 6}, {1, 11}, {2, 10}, {2, 13}, {2, 19}, {3, 19}, {4, 22}, {5, 26}, {5, 37}};
    private static final int SALT_LENGTH_BYTES = 16;
    private static final int HASH_LENGTH_BYTES = 16;
    private static final int DEFAULT_ITERATIONS = 2;
    private static final int DEFAULT_MEMORY_MB = 19;
    private static final int DEFAULT_LANES = 1;
    private static final byte[] DEFAULT_PEPPER = "Ineffable_24".getBytes(StandardCharsets.US_ASCII);
    private final int iterations;
    private final int memLimitMb;
    private final int parallelism;
    private final byte[] pepper;

    ArgonPassword(int iterations, int memLimitMb, int parallelism) {
        super(16, true);
        this.iterations = iterations;
        this.memLimitMb = memLimitMb;
        this.parallelism = parallelism;
        this.pepper = DEFAULT_PEPPER;
    }

    public int getIterations() {
        return this.iterations;
    }

    public int getMemLimitMb() {
        return this.memLimitMb;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public static ArgonPassword getInstance(String algorithm) throws PasswordFormatException {
        if (algorithm.isEmpty() || algorithm.charAt(0) != 'a') {
            throw new PasswordFormatException("Algorithm code not start with 'a'");
        }
        try {
            String raw = algorithm.substring(1);
            if (raw.isEmpty()) {
                return new ArgonPassword(2, 19, 1);
            }
            int[] parameters = ArgonPassword.asParameters(raw.split(":"));
            int iterations = parameters.length > 0 ? parameters[0] : 2;
            int memLimitMb = parameters.length > 1 ? parameters[1] : 19;
            int parallelism = parameters.length > 2 ? parameters[2] : 1;
            return new ArgonPassword(iterations, memLimitMb, parallelism);
        }
        catch (NumberFormatException ex) {
            throw new PasswordFormatException("Invalid algorithm parameter");
        }
    }

    public static ArgonPassword getPreset(String algorithm) throws PasswordFormatException {
        if (algorithm.length() < 2 || algorithm.charAt(0) != 'p') {
            throw new PasswordFormatException("Algorithm code does not start with 'p'");
        }
        try {
            int preset = Integer.parseInt(Character.toString(algorithm.charAt(1)));
            int iterations = PRESETS[preset][0];
            int memLimitMb = PRESETS[preset][1];
            return new ArgonPassword(iterations, memLimitMb, 1);
        }
        catch (NumberFormatException ex) {
            throw new PasswordFormatException("Algorithm code does not specify power");
        }
    }

    private static int[] asParameters(String[] values) {
        int[] parameters = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            parameters[i] = Integer.parseInt(values[i]);
        }
        return parameters;
    }

    @Override
    public boolean check(String enteredPassword, String storedPassword) {
        String[] tokens = storedPassword.split("\\$");
        if (tokens.length != 3) {
            throw new IllegalArgumentException();
        }
        String salt = tokens[1];
        String hash = tokens[2];
        return this.generateHash(enteredPassword, salt).equals(hash);
    }

    @Override
    public byte[] generateHash(String password, byte[] salt) {
        Argon2Parameters.Builder builder = new Argon2Parameters.Builder(2).withVersion(19).withIterations(this.iterations).withMemoryAsKB(this.memLimitMb * 1024).withParallelism(this.parallelism).withSecret(this.pepper).withSalt(salt);
        Argon2BytesGenerator generate = new Argon2BytesGenerator();
        generate.init(builder.build());
        byte[] hash = new byte[16];
        generate.generateBytes(password.getBytes(StandardCharsets.UTF_8), hash, 0, hash.length);
        return hash;
    }

    @Override
    String format(byte[] salt, byte[] hash) {
        return "a" + this.iterations + ":" + this.memLimitMb + ":" + this.parallelism + "$" + this.asString(salt) + "$" + this.asString(hash);
    }

    public String toString() {
        return "Argon(t=" + this.iterations + ",m=" + this.memLimitMb + ",p=" + this.parallelism + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof ArgonPassword)) {
            return false;
        }
        ArgonPassword that = (ArgonPassword)o;
        return this.iterations == that.iterations && this.memLimitMb == that.memLimitMb && this.parallelism == that.parallelism && Arrays.equals(this.pepper, that.pepper);
    }

    public int hashCode() {
        int result = this.iterations;
        result = 31 * result + this.memLimitMb;
        result = 31 * result + this.parallelism;
        result = 31 * result + Arrays.hashCode(this.pepper);
        return result;
    }
}

