/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.security;

import com.pageseeder.base.security.GCM;
import com.pageseeder.common.util.BinaryFormat;
import org.eclipse.jdt.annotation.Nullable;

public final class AntiCSRFToken {
    private static final String KEY_ALIAS = "csrf-gcm";
    private final String sessionId;

    private AntiCSRFToken(String sessionId) {
        this.sessionId = sessionId;
    }

    public String sessionId() {
        return this.sessionId;
    }

    public String generateToken() {
        return GCM.encryptSilently(KEY_ALIAS, this.sessionId, BinaryFormat.BASE_64_URL);
    }

    public static String generateToken(String sessionId) {
        AntiCSRFToken token = new AntiCSRFToken(sessionId);
        return token.generateToken();
    }

    public static @Nullable AntiCSRFToken parse(String token) {
        String sessionId = GCM.decryptSilently(KEY_ALIAS, token, BinaryFormat.BASE_64_URL);
        if (sessionId != null) {
            return new AntiCSRFToken(sessionId);
        }
        return null;
    }
}

