/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.rule;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.util.XMLHelpers;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class MemberDetailsConfig
implements XMLWritable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemberDetailsConfig.class);
    public static final int MAX_FIELDS_COUNT = 15;
    private final @Nullable FieldConfig[] fields = new FieldConfig[15];
    private boolean shared = false;

    public @Nullable FieldConfig getFieldConfig(int i) {
        return this.fields[i - 1];
    }

    public boolean isShared() {
        return this.shared;
    }

    public boolean isDefined(int i) {
        return this.fields[i - 1] != null;
    }

    public boolean isEditable(int i) {
        FieldConfig field = this.fields[i - 1];
        return field != null && field.isEditable();
    }

    public boolean isVisibleTo(int i, @Nullable Visibility visibility) {
        if (visibility == null) {
            return false;
        }
        FieldConfig field = this.fields[i - 1];
        return field != null && field.isVisibleTo(visibility);
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("member-details", true);
        xml.attribute("shared", Boolean.toString(this.shared));
        for (FieldConfig field : this.fields) {
            if (field == null) continue;
            field.toXML(xml);
        }
        xml.closeElement();
    }

    public void toXML(XMLWriter xml, int p, String value) throws IOException {
        FieldConfig field = this.fields[p - 1];
        if (field != null) {
            field.toXML(xml, value);
        }
    }

    public static MemberDetailsConfig parse(File file) throws FoundationException {
        MemberDetailsConfig config = new MemberDetailsConfig();
        LOGGER.debug("Parsing XML {}", (Object)file.getPath());
        try {
            SAXParserFactory factory = XMLHelpers.safeSAXParserFactory();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            SAXParser parser = factory.newSAXParser();
            Handler handler = new Handler(config);
            parser.parse(file, (DefaultHandler)handler);
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new FoundationException("Unable to parse member details configuration", ex);
        }
        return config;
    }

    public static MemberDetailsConfig loadProperties(File file) throws FoundationException {
        MemberDetailsConfig config = new MemberDetailsConfig();
        Properties properties = new Properties();
        LOGGER.debug("Parsing properties {}", (Object)file.getPath());
        try (FileInputStream in = new FileInputStream(file);){
            properties.load(in);
            config.shared = "true".equals(properties.getProperty("shared"));
            int position = 0;
            int listed = Integer.parseInt(properties.getProperty("listed", "0"));
            for (int j = 0; j < listed; ++j) {
                FieldConfig field = new FieldConfig(++position);
                field.setEditable(true);
                field.setVisibility(Visibility.GROUP);
                config.fields[field.position() - 1] = field;
            }
            int writable = Integer.parseInt(properties.getProperty("writable", "0"));
            for (int j = 0; j < writable; ++j) {
                FieldConfig field = new FieldConfig(++position);
                field.setEditable(true);
                field.setVisibility(Visibility.MEMBER);
                config.fields[field.position() - 1] = field;
            }
            int readonly = Integer.parseInt(properties.getProperty("readonly", "0"));
            for (int j = 0; j < readonly; ++j) {
                FieldConfig field = new FieldConfig(++position);
                field.setVisibility(Visibility.MEMBER);
                config.fields[field.position() - 1] = field;
            }
            int hidden = Integer.parseInt(properties.getProperty("hidden", "0"));
            for (int j = 0; j < hidden; ++j) {
                FieldConfig field = new FieldConfig(++position);
                field.setVisibility(Visibility.MANAGER);
                config.fields[field.position() - 1] = field;
            }
        }
        catch (IOException | NumberFormatException ex) {
            throw new FoundationException("Unable to load properties file", ex);
        }
        return config;
    }

    private static class Handler
    extends DefaultHandler {
        private final MemberDetailsConfig config;

        protected Handler(MemberDetailsConfig config) {
            this.config = config;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("field".equals(qName)) {
                int position = Handler.toPosition(attributes.getValue("position"));
                if (position > 0) {
                    String type;
                    String name = Handler.toName(attributes.getValue("name"), position);
                    FieldConfig field = new FieldConfig(position, name);
                    String title = attributes.getValue("title");
                    if (title != null && !title.isEmpty()) {
                        field.setTitle(title);
                    }
                    if ((type = attributes.getValue("type")) != null && !type.isEmpty()) {
                        field.setType(type);
                    }
                    field.setEditable(Handler.toBoolean(attributes.getValue("editable")));
                    Visibility visibility = Handler.toVisibility(attributes.getValue("visibility"));
                    if (visibility != null) {
                        field.setVisibility(visibility);
                    }
                    if (this.config.fields[position - 1] != null) {
                        LOGGER.warn("Field was {} was defined twice", (Object)position);
                    }
                    this.config.fields[position - 1] = field;
                }
            } else if ("member-details".equals(qName)) {
                this.config.shared = "true".equals(attributes.getValue("shared"));
            }
        }

        private static int toPosition(String position) {
            int i = -1;
            try {
                i = Integer.parseInt(position);
                if (i < 1 || i > 15) {
                    LOGGER.warn("Field position out of range: got '{}' expected number between 1 and 15", (Object)position);
                    i = -1;
                }
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warn("Unable to parse position of field: got '{}' expected number between 1 and 15", (Object)position);
            }
            return i;
        }

        private static @Nullable String toName(@Nullable String value, int position) {
            String name = null;
            if (value != null) {
                if (value.isEmpty()) {
                    LOGGER.warn("The name of field #{} is an empty string", (Object)position);
                } else if (!value.matches("\\w+")) {
                    LOGGER.warn("The name of field #{} is invalid: '{}'", (Object)position, (Object)value);
                } else {
                    name = value;
                }
            }
            return name;
        }

        private static boolean toBoolean(@Nullable String value) {
            if (value == null) {
                return false;
            }
            boolean yes = "true".equals(value);
            if (!yes && !"false".equals(value)) {
                LOGGER.warn("Invalid boolean value '{}' expected 'true' or 'false'", (Object)value);
            }
            return yes;
        }

        private static @Nullable Visibility toVisibility(@Nullable String value) {
            if (value == null) {
                return null;
            }
            String upper = value.toUpperCase();
            for (Visibility v : Visibility.values()) {
                if (!v.name().equals(upper)) continue;
                return v;
            }
            LOGGER.warn("Invalid visibility value '{}' expected 'group', 'member' or 'manager'", (Object)value);
            return null;
        }
    }

    public static final class FieldConfig
    implements XMLWritable {
        private final int p;
        private final String name;
        private @Nullable String title;
        private @Nullable String type;
        private boolean editable = false;
        private Visibility visibility = Visibility.MANAGER;

        FieldConfig(int i) {
            this(i, null);
        }

        FieldConfig(int p, @Nullable String name) {
            if (p < 1 || p > 15) {
                throw new IllegalArgumentException("field position must be less than 1 or greater than 15");
            }
            this.p = p;
            this.name = name != null ? name : "field" + p;
        }

        public String name() {
            return this.name;
        }

        public int position() {
            return this.p;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public Visibility getVisibility() {
            return this.visibility;
        }

        public boolean isVisibleTo(Visibility visibility) {
            return visibility.ordinal() >= this.visibility.ordinal();
        }

        public @Nullable String getTitle() {
            return this.title;
        }

        public @Nullable String getType() {
            return this.type;
        }

        protected void setEditable(boolean editable) {
            this.editable = editable;
        }

        protected void setVisibility(Visibility visibility) {
            this.visibility = visibility;
        }

        protected void setTitle(String title) {
            this.title = title;
        }

        protected void setType(String type) {
            this.type = type;
        }

        public void toXML(XMLWriter xml) throws IOException {
            xml.openElement("field");
            xml.attribute("position", this.p);
            xml.attribute("name", this.name);
            xml.attribute("editable", Boolean.toString(this.editable));
            xml.attribute("visibility", this.visibility.toString());
            if (this.title != null) {
                xml.attribute("title", this.title);
            }
            if (this.type != null) {
                xml.attribute("type", this.type);
            }
            xml.closeElement();
        }

        public void toXML(XMLWriter xml, @Nullable String value) throws IOException {
            xml.openElement("field");
            xml.attribute("position", this.p);
            xml.attribute("name", this.name);
            xml.attribute("editable", Boolean.toString(this.editable));
            if (this.title != null) {
                xml.attribute("title", this.title);
            }
            if (this.type != null) {
                xml.attribute("type", this.type);
            }
            if (value != null) {
                xml.writeText(value);
            }
            xml.closeElement();
        }
    }

    public static enum Visibility {
        GROUP,
        MEMBER,
        MANAGER;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

