/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.rule;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.GroupProperties;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.HostRule;
import com.pageseeder.base.rule.Notification;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.Rules;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.util.Flags;
import com.pageseeder.db.util.GroupURIs;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.jdt.annotation.Nullable;

public class GroupMediator {
    public static final String PUBLIC = "public";
    public static final String MEMBER = "member";
    public static final String REVIEWER = "reviewer";
    public static final String CONTRIBUTOR = "contributor";
    public static final String EMAIL = "email";
    public static final String ALL = "all";
    public static final String NORMAL = "normal";
    public static final String MODERATED = "moderated";
    public static final String CONFIRMED = "confirmed";
    public static final String IMMEDIATE = "immediate";
    public static final String DAILY = "daily";
    public static final String WEEKLY = "weekly";
    public static final String ESSENTIAL = "essential";
    public static final String NONE = "none";
    private Database db;
    private @Nullable String projectname = null;
    private @Nullable Group projectgroup = null;
    private @Nullable Host host = null;
    private @Nullable String shortname = null;
    private @Nullable String groupname = null;
    private @Nullable String title = null;
    private @Nullable String description;
    private boolean project = false;
    private @Nullable Member manager = null;
    private @Nullable String owner = null;
    private @Nullable String visibility = null;
    private @Nullable String template = null;
    private @Nullable String detailstype = null;
    private @Nullable String relatedurl = null;
    private @Nullable String message = null;
    private @Nullable String access = null;
    private @Nullable String commenting = null;
    private @Nullable String moderation = null;
    private @Nullable String registration = null;
    private @Nullable String defaultrole = null;
    private @Nullable String defaultnotify = null;
    private @Nullable Boolean common = null;
    private @Nullable Boolean editurls = null;
    private Properties properties = new Properties();

    public GroupMediator(Database db) {
        this.db = db;
    }

    public GroupMediator(Database db, @Nullable String projectname, String shortname, String description, @Nullable String hostname, @Nullable Member manager) throws FoundationException, DatabaseException {
        this.db = db;
        if (projectname != null) {
            this.projectgroup = DatabaseQuery.getGroupByName((Database)this.db, (String)projectname);
            if (this.projectgroup == null) {
                throw new FoundationException("Project named " + projectname + " does not exist.");
            }
            if (!GroupRule.isProject(this.projectgroup)) {
                throw new FoundationException("Project named " + projectname + " is not a project.");
            }
        } else if (hostname == null) {
            throw new FoundationException("The hosturl must be specified if projectname is not.");
        }
        if (hostname != null) {
            this.host = HostRule.resolveHost(db, hostname);
            if (this.host == null) {
                throw new FoundationException("The host does not exist.");
            }
        }
        this.projectname = projectname;
        String fullname = (String)(this.projectname != null ? this.projectname + "-" : "") + shortname;
        if (!GroupRule.isValidGroupName(fullname)) {
            throw new FoundationException("The shortname is not a valid project/group name.");
        }
        if (fullname.length() > 60) {
            throw new FoundationException("The projectname + shortname must be less than 60 characters.");
        }
        if (DatabaseQuery.getGroupByName((Database)this.db, (String)fullname) != null) {
            throw new FoundationException("Group or project named " + fullname + " already exists.");
        }
        if (fullname.indexOf(45) != -1) {
            String name = fullname.substring(0, fullname.lastIndexOf(45));
            Group project = DatabaseQuery.getGroupByName((Database)db, (String)name);
            if (project == null) {
                throw new FoundationException("Parent project " + name + " is missing.");
            }
            if (!GroupRule.isProject(project)) {
                throw new FoundationException("Parent project " + name + " is a group.");
            }
        }
        this.groupname = fullname;
        this.shortname = shortname;
        this.setDescription(description);
        this.manager = manager;
    }

    public void setTitle(@Nullable String title) throws FoundationException {
        if (title != null && title.length() > 100) {
            throw new FoundationException("The title can not be more than 100 characters.");
        }
        this.title = title;
    }

    public void setDescription(@Nullable String description) throws FoundationException {
        if (description != null && description.length() > 250) {
            throw new FoundationException("The description can not be more than 250 characters.");
        }
        this.description = description;
    }

    public void setProject(boolean project) {
        this.project = project;
    }

    public void setOwner(@Nullable String owner) throws FoundationException {
        if (owner != null && owner.length() > 100) {
            throw new FoundationException("The owner can not be more than 100 characters.");
        }
        this.owner = owner;
    }

    public void setVisibility(@Nullable String visibility) throws FoundationException {
        if (!(visibility == null || GroupRule.isValidGroupName(visibility) || visibility.startsWith(MEMBER) || PUBLIC.equals(visibility))) {
            throw new FoundationException("The visibility must be a valid group name or 'public'.");
        }
        this.visibility = visibility;
    }

    public void setTemplate(@Nullable String template) throws FoundationException {
        if (template != null && (!GroupRule.isValidGroupName(template) && !template.startsWith(MEMBER) || template.length() > 60)) {
            throw new FoundationException("The template must be a valid project name and not more than 60 characters.");
        }
        this.template = template;
    }

    public void setDetailstype(@Nullable String detailstype) throws FoundationException {
        if (detailstype != null && detailstype.length() > 150) {
            throw new FoundationException("The detailstype can not be more than 150 characters.");
        }
        this.detailstype = detailstype;
    }

    public void setRelatedurl(@Nullable String relatedurl) throws FoundationException {
        if (relatedurl != null && relatedurl.length() > 250) {
            throw new FoundationException("The relatedurl can not be more than 250 characters.");
        }
        this.relatedurl = relatedurl;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setAccess(String access) throws FoundationException {
        if (!PUBLIC.equals(access) && !MEMBER.equals(access)) {
            throw new FoundationException("The access must be 'public' or 'member'.");
        }
        this.access = access;
    }

    public void setCommenting(String commenting) throws FoundationException {
        if (!(PUBLIC.equals(commenting) || REVIEWER.equals(commenting) || CONTRIBUTOR.equals(commenting))) {
            throw new FoundationException("The commenting must be 'public','reviewer' or 'contributor'.");
        }
        this.commenting = commenting;
    }

    public void setModeration(String moderation) throws FoundationException {
        if (!(REVIEWER.equals(moderation) || EMAIL.equals(moderation) || ALL.equals(moderation))) {
            throw new FoundationException("The moderation must be 'reviewer','email' or 'all'.");
        }
        this.moderation = moderation;
    }

    public void setRegistration(String registration) throws FoundationException {
        if (!(NORMAL.equals(registration) || MODERATED.equals(registration) || CONFIRMED.equals(registration))) {
            throw new FoundationException("The registration must be 'normal','moderated' or 'confirmed'.");
        }
        this.registration = registration;
    }

    public void setDefaultrole(String defaultrole) throws FoundationException {
        if (!REVIEWER.equals(defaultrole) && !CONTRIBUTOR.equals(defaultrole)) {
            throw new FoundationException("The defaultrole must be 'reviewer' or 'contributor'.");
        }
        this.defaultrole = defaultrole;
    }

    public void setDefaultnotify(String defaultnotify) throws FoundationException {
        if (!(IMMEDIATE.equals(defaultnotify) || DAILY.equals(defaultnotify) || WEEKLY.equals(defaultnotify) || ESSENTIAL.equals(defaultnotify) || NONE.equals(defaultnotify))) {
            throw new FoundationException("The defaultnotify must be 'immediate','daily','weekly','essential' or 'none'.");
        }
        this.defaultnotify = defaultnotify;
    }

    public void setCommon(Boolean common) {
        this.common = common;
    }

    public void setEditURLs(Boolean editurls) {
        this.editurls = editurls;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public Group create(boolean admin, boolean projectManager) throws FoundationException, DatabaseException {
        int host_port;
        String host_name;
        String host_protocol;
        Long n;
        Long n2;
        if (this.shortname == null || this.description == null) {
            throw new FoundationException("The shortname and description must be specified to create a group/project.");
        }
        if (this.projectname == null && this.owner == null) {
            throw new FoundationException("The owner must be specified if projectname is not.");
        }
        if (!this.project && this.projectname == null) {
            throw new FoundationException("The projectname must be specified to create a group.");
        }
        String pathNew = GlobalSettings.getSitePrefix() + "/" + this.groupname.replace('-', '/') + (this.project ? "/%" : "/*");
        String uriPath = GroupURIs.truncatePath((String)pathNew);
        assert (uriPath != null);
        String directory = URIRule.getRealPath(Settings.getContextPath(), uriPath);
        File groupDirectory = new File(directory);
        if (groupDirectory.exists()) {
            throw new FoundationException("The default folder " + uriPath + " is already in use.");
        }
        String pr = GlobalSettings.getString((String)"projects", (String)"unlimited");
        if (!"unlimited".equals(pr) && this.project && (n2 = DatabaseQuery.getNumberNonArchivedProjects((Database)this.db)) + 1L > (long)Integer.parseInt(pr)) {
            throw new FoundationException("Maximum number of projects reached for PageSeeder license.");
        }
        String tp = GlobalSettings.get((String)"groups");
        if (!"unlimited".equals(tp) && (n = DatabaseQuery.getNumberNonMemberGroups((Database)this.db)) + 1L > (long)(Integer.parseInt(tp) + 2)) {
            throw new FoundationException("Maximum number of groups reached for PageSeeder license.");
        }
        Group grp = Group.create((Database)this.db);
        grp.setName(this.groupname);
        grp.setTitle(this.title);
        grp.setDescription(this.description);
        grp.setControlGroupName(this.visibility != null && admin ? this.visibility : this.groupname);
        if (admin || projectManager) {
            grp.setDetailsForm(this.detailstype);
        }
        grp.setOwner(this.owner != null && admin ? this.owner : this.projectgroup.getOwner());
        grp.setMessage(this.message);
        grp.setHomeURL(this.relatedurl);
        grp.setOwnerDirectory(this.template != null && admin ? this.template : (this.project ? this.groupname : this.projectgroup.getOwnerDirectory()));
        grp.setFlags(this.updateFlags("", admin, !this.properties.isEmpty()));
        grp = grp.insert(this.db);
        if (!this.properties.isEmpty()) {
            try {
                GroupProperties.set(this.db, grp, this.properties);
            }
            catch (IOException ex) {
                throw new FoundationException("Unable to create properties: " + ex.getMessage(), ex);
            }
        }
        Group pub = GroupRule.getPublicGroup(this.db);
        Collection pub_guri = pub.getGroupURIsCol();
        Collection grp_uric = grp.getGroupURIsCol();
        if (this.host != null) {
            host_protocol = Settings.getDocumentScheme();
            host_name = this.host.getName();
            host_port = Settings.getDocumentPort();
            if (host_port == -1) {
                host_port = Rules.getDefaultPort((String)host_protocol);
            }
        } else {
            GroupURI project_guri = GroupURIRule.getDefaultGroupURI(this.projectgroup);
            if (project_guri == null) {
                throw new FoundationException("The project " + this.projectgroup.getName() + " does not have a default folder.");
            }
            host_protocol = project_guri.getScheme();
            host_name = project_guri.getHost().getName();
            host_port = project_guri.getPort();
        }
        GroupURIRule.addGroupURIForSchemeHostPortPath(this.db, pub, pub_guri, grp, grp_uric, host_protocol, host_name, host_port, pathNew, PUBLIC.equals(this.access), !this.project);
        if (!this.project) {
            String path = GlobalSettings.get((String)"servletPrefix") + "/com.pageseeder.general/" + grp.getId() + "/*";
            GroupURIRule.addGroupURIForSchemeHostPortPath(this.db, pub, pub_guri, grp, grp_uric, host_protocol, host_name, host_port, path, PUBLIC.equals(this.access), false);
        }
        if (this.manager != null) {
            MemberForGroup mfg = MemberForGroup.create((Database)this.db);
            mfg.setListed(Boolean.TRUE);
            mfg.setNotification("Immediate");
            mfg.setMember(this.manager);
            mfg.setEditor(Boolean.TRUE);
            mfg.setEditorFlags("e");
            grp.addMembersForGroup(mfg);
            mfg.insert(this.db);
        }
        if (!groupDirectory.mkdirs()) {
            throw new FoundationException("Default folder " + groupDirectory.getAbsolutePath() + " could not be created.");
        }
        return grp;
    }

    public boolean edit(Group grp, boolean admin, boolean projectManager, boolean editProperties) throws FoundationException, DatabaseException {
        String pr = GlobalSettings.getString((String)"projects", (String)"unlimited");
        if (!("unlimited".equals(pr) || !this.project || grp.getFlags() != null && grp.getFlags().contains("f"))) {
            int maxProjectsAllowed;
            Long n = DatabaseQuery.getNumberNonArchivedProjects((Database)this.db);
            int n2 = maxProjectsAllowed = pr.matches("\\D+") ? Integer.parseInt(pr) : 0;
            if (n + 1L > (long)maxProjectsAllowed) {
                throw new FoundationException("Maximum number of projects reached for PageSeeder license.");
            }
        }
        boolean modified = false;
        if (this.title != null) {
            if (!this.title.equals(grp.getTitle())) {
                modified = true;
            }
            grp.setTitle(this.title);
        }
        if (this.description != null) {
            if (!this.description.equals(grp.getDescription())) {
                modified = true;
            }
            grp.setDescription(this.description);
        }
        if (this.message != null) {
            if (!this.message.equals(grp.getMessage())) {
                modified = true;
            }
            grp.setMessage(this.message);
        }
        if (this.relatedurl != null) {
            if (!this.relatedurl.equals(grp.getHomeURL())) {
                modified = true;
            }
            grp.setHomeURL(this.relatedurl);
        }
        if ((admin || projectManager) && this.detailstype != null) {
            if (!this.detailstype.equals(grp.getDetailsForm())) {
                modified = true;
            }
            grp.setDetailsForm(this.detailstype);
        }
        if (admin) {
            if (this.visibility != null) {
                if (!this.visibility.toLowerCase().equals(grp.getControlGroupName())) {
                    modified = true;
                }
                grp.setControlGroupName(this.visibility.toLowerCase());
            }
            if (this.owner != null) {
                if (!this.owner.equals(grp.getOwner())) {
                    modified = true;
                }
                grp.setOwner(this.owner);
            }
            if (this.template != null) {
                if (!this.template.equals(grp.getOwnerDirectory())) {
                    modified = true;
                }
                grp.setOwnerDirectory(this.template);
            }
        }
        this.project = GroupRule.isProject(grp);
        String before = grp.getFlags();
        grp.setFlags(this.updateFlags(grp.getFlags(), admin, editProperties));
        if (before == null && grp.getFlags() != null || before != null && grp.getFlags() == null || before != null && !before.equals(grp.getFlags())) {
            modified = true;
        }
        if (editProperties) {
            if (this.properties.isEmpty()) {
                GroupProperties.remove(this.db, grp);
            } else {
                try {
                    GroupProperties.set(this.db, grp, this.properties);
                }
                catch (IOException ex) {
                    throw new FoundationException("Unable to create properties: " + ex.getMessage(), ex);
                }
            }
        }
        return modified;
    }

    private String updateFlags(String flags, boolean admin, boolean editProperties) {
        if (this.registration != null) {
            if (MODERATED.equals(this.registration)) {
                flags = Flags.add((String)flags, (char)'r');
                flags = Flags.remove((String)flags, (char)'c');
            } else if (CONFIRMED.equals(this.registration)) {
                flags = Flags.add((String)flags, (char)'c');
                flags = Flags.remove((String)flags, (char)'r');
            } else {
                flags = Flags.remove((String)flags, (char)'c');
                flags = Flags.remove((String)flags, (char)'r');
            }
        }
        if (this.defaultrole != null) {
            flags = CONTRIBUTOR.equals(this.defaultrole) ? Flags.add((String)flags, (char)'t') : Flags.remove((String)flags, (char)'t');
        }
        if (this.defaultnotify != null) {
            Notification notify = Notification.forType(this.defaultnotify);
            if (notify != null && notify.flag() != null) {
                flags = Flags.add((String)flags, (char)notify.flag().charValue());
            }
            for (Notification other : Notification.values()) {
                if (other == notify || other.flag() == null) continue;
                flags = Flags.remove((String)flags, (char)other.flag().charValue());
            }
        }
        if (this.commenting != null) {
            if (PUBLIC.equals(this.commenting)) {
                flags = Flags.add((String)flags, (char)'a');
                flags = Flags.remove((String)flags, (char)'o');
            } else if (CONTRIBUTOR.equals(this.commenting)) {
                flags = Flags.add((String)flags, (char)'o');
                flags = Flags.remove((String)flags, (char)'a');
            } else {
                flags = Flags.remove((String)flags, (char)'a');
                flags = Flags.remove((String)flags, (char)'o');
            }
        }
        if (this.moderation != null) {
            flags = EMAIL.equals(this.moderation) ? Flags.remove((String)flags, (char)'e') : Flags.add((String)flags, (char)'e');
            flags = ALL.equals(this.moderation) ? Flags.add((String)flags, (char)'g') : Flags.remove((String)flags, (char)'g');
        }
        if (this.common != null) {
            flags = this.common != false ? Flags.add((String)flags, (char)'m') : Flags.remove((String)flags, (char)'m');
        }
        if (editProperties) {
            flags = this.properties.isEmpty() ? Flags.remove((String)flags, (char)'v') : Flags.add((String)flags, (char)'v');
        }
        if (admin) {
            if (this.access != null) {
                flags = PUBLIC.equals(this.access) ? Flags.add((String)flags, (char)'p') : Flags.remove((String)flags, (char)'p');
            }
            if (this.editurls != null) {
                String before = flags;
                flags = this.editurls != false ? Flags.add((String)flags, (char)'u') : Flags.remove((String)flags, (char)'u');
                if (before == null && flags != null || before != null && !before.equals(flags)) {
                    new UserDetailsManager().removeAll();
                }
            }
            flags = this.project ? Flags.add((String)flags, (char)'f') : Flags.remove((String)flags, (char)'f');
        }
        return flags;
    }
}

