/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.organization;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.mail.EmailSender;
import com.pageseeder.base.organization.ConfigHandler;
import com.pageseeder.base.organization.ConfigSupplier;
import com.pageseeder.base.organization.EmailConfig;
import com.pageseeder.base.organization.SecurityConfig;
import com.pageseeder.base.organization.UIConfig;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class OrganizationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrganizationManager.class);
    public static final String ORGANIZATION_CONFIG_SCHEMA = "ps://com/pageseeder/base/organization/organization-config.xsd";
    private static @Nullable OrganizationManager instance = null;
    private final Map<String, EmailConfig> emailConfigs;
    private final UIConfig uiConfig;
    private final SecurityConfig securityConfig;
    private final boolean disabled;
    private final boolean error;

    private OrganizationManager(Map<String, EmailConfig> emailConfigs, UIConfig uiConfig, SecurityConfig securityConfig, boolean disabled, boolean error) {
        this.emailConfigs = emailConfigs;
        this.uiConfig = uiConfig;
        this.securityConfig = securityConfig;
        this.disabled = disabled;
        this.error = error;
    }

    public static synchronized OrganizationManager instance() {
        if (instance == null) {
            instance = new OrganizationManager(new HashMap<String, EmailConfig>(), new UIConfig.Builder().build(), new SecurityConfig.Builder().build(), false, false);
        }
        return instance;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean hasError() {
        return this.error;
    }

    public @Nullable EmailConfig getEmailConfig(String template) {
        return this.emailConfigs.get(template);
    }

    public Set<String> getEmailConfigTemplates() {
        return this.emailConfigs.keySet();
    }

    public static RSAPrivateKey getDKIMPrivateKey(String template) throws IOException {
        Object path = "";
        try {
            InputStream dkimIn;
            if ("default".equals(template)) {
                dkimIn = EmailSender.class.getResourceAsStream("/com/pageseeder/base/mail/psmail.private.key.der");
            } else {
                path = Settings.getContextPath() + "WEB-INF" + File.separator + "config" + File.separator + "template" + File.separator + template + File.separator + "organization" + File.separator + "email-private-key.der";
                dkimIn = new FileInputStream((String)path);
            }
            byte[] privKeyBytes = IOUtils.toByteArray((InputStream)dkimIn);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(privKeyBytes);
            return (RSAPrivateKey)keyFactory.generatePrivate(privSpec);
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException ex) {
            LOGGER.error("DKIM private key invalid " + (String)path, (Throwable)ex);
            throw new IOException("DKIM private key invalid " + (String)path, ex);
        }
    }

    public static void validateDKIMPrivateKeys(Map<String, EmailConfig> emailConfigs) throws IOException {
        for (Map.Entry<String, EmailConfig> entry : emailConfigs.entrySet()) {
            EmailConfig config = entry.getValue();
            if (config.getDKIMDomain() == null || config.getDKIMSelector() == null) continue;
            OrganizationManager.getDKIMPrivateKey(entry.getKey());
        }
    }

    public boolean canLogin(UserDetails details) {
        String flags;
        if (MemberRule.isAdministrator(details.flags())) {
            return true;
        }
        List<String> orgGroups = this.securityConfig.getLoginGroups();
        List<String> orgProjects = this.securityConfig.getLoginProjects();
        if (orgGroups.isEmpty() && orgProjects.isEmpty()) {
            return true;
        }
        Map<String, String> flagmap = details.flags();
        for (String group : orgGroups) {
            flags = flagmap.get(group);
            if (flags == null || flags.contains("i")) continue;
            return true;
        }
        for (String project : orgProjects) {
            flags = flagmap.get(project);
            if (flags == null) continue;
            return true;
        }
        return false;
    }

    public UIConfig getUIConfig() {
        return this.uiConfig;
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrganizationManager load() {
        boolean hasError = false;
        String pk = GlobalSettings.getString((String)String.join((CharSequence)"", "pr", "od", "uc", "tK", "ey"), (String)"");
        ConfigSupplier supplier = new ConfigSupplier();
        try {
            if (pk.equals(String.join((CharSequence)"", "d", "ev")) || pk.startsWith("s") && pk.length() == 28) {
                return this.load(GlobalSettings.getGlobalTemplate(), true, supplier.isOrganizationDisabled(), supplier);
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage());
            hasError = true;
        }
        Class<OrganizationManager> clazz = OrganizationManager.class;
        synchronized (OrganizationManager.class) {
            instance = new OrganizationManager(new HashMap<String, EmailConfig>(), new UIConfig.Builder().build(), new SecurityConfig.Builder().build(), supplier.isOrganizationDisabled(), hasError);
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OrganizationManager load(@Nullable String globalTemplate, boolean validateDKIM, boolean disabled, Supplier<Map<String, File>> configsSupplier) throws IOException {
        Class<OrganizationManager> clazz = OrganizationManager.class;
        synchronized (OrganizationManager.class) {
            HashMap<String, EmailConfig> emailConfigs = new HashMap<String, EmailConfig>();
            UIConfig.Builder uiBuilder = new UIConfig.Builder();
            SecurityConfig.Builder securityBuilder = new SecurityConfig.Builder();
            ArrayList errors = new ArrayList();
            configsSupplier.get().forEach((template, file) -> {
                try (FileInputStream config = new FileInputStream((File)file);){
                    this.validate((String)template, (File)file, errors);
                    EmailConfig.Builder emailBuilder = new EmailConfig.Builder();
                    if (template.equals(globalTemplate)) {
                        this.parse((String)template, (File)file, emailBuilder, uiBuilder, securityBuilder, errors);
                    } else {
                        this.parse((String)template, (File)file, emailBuilder, new UIConfig.Builder(), new SecurityConfig.Builder(), errors);
                    }
                    emailConfigs.put((String)template, emailBuilder.build());
                }
                catch (Exception ex) {
                    errors.add("Error loading organization-config.xml for template " + template + ": " + ex.getMessage());
                }
            });
            if (!errors.isEmpty()) {
                for (String msg : errors) {
                    LOGGER.error(msg);
                }
                throw new IOException("Error loading organization-config.xml, see general.log for details.");
            }
            if (validateDKIM) {
                OrganizationManager.validateDKIMPrivateKeys(emailConfigs);
            }
            instance = new OrganizationManager(emailConfigs, uiBuilder.build(), securityBuilder.build(), disabled, false);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return instance;
        }
    }

    private void validate(String template, File file, List<String> validationErrors) {
        try (FileInputStream config = new FileInputStream(file);){
            List<String> errors = XMLHelpers.validateXmlFileWithSchemaReturnErrors(config, ORGANIZATION_CONFIG_SCHEMA, null);
            if (errors != null && !errors.isEmpty()) {
                validationErrors.add("Error validating organization-config.xml for template " + template);
                validationErrors.addAll(errors);
            }
        }
        catch (IOException | SAXException ex) {
            validationErrors.add("Error validating organization-config.xml for template " + template + ": " + ex.getMessage());
        }
    }

    private void parse(String template, File file, EmailConfig.Builder emailBuilder, UIConfig.Builder uiBuilder, SecurityConfig.Builder securityBuilder, List<String> errors) {
        ConfigHandler handler = new ConfigHandler(emailBuilder, uiBuilder, securityBuilder);
        try (FileInputStream config = new FileInputStream(file);){
            XMLHelpers.parse(config, handler);
        }
        catch (FoundationException | IOException ex) {
            errors.add("Error parsing organization-config.xml for template " + template + ": " + ex.getMessage() + (String)(ex.getCause() != null ? ", " + ex.getCause().getMessage() : ""));
        }
    }
}

