/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.openid;

import com.pageseeder.base.oauth.jwt.JWTClaimSet;
import com.pageseeder.db.CommitTransactionException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.oauth.Scope;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClaimsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClaimsProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JWTClaimSet getClaims(Database db, Long memberId, Set<Scope> scopes) {
        JWTClaimSet claims = new JWTClaimSet();
        Transaction tr = new Transaction(db);
        try {
            Member member = DatabaseQuery.getMemberById((Database)db, (Long)memberId);
            if (scopes.contains(Scope.PROFILE) && member != null) {
                String givenName = Objects.toString(member.getFirstName(), "");
                String familyName = Objects.toString(member.getSurname(), "");
                claims.addClaim("name", givenName + " " + familyName);
                claims.addClaim("given_name", givenName);
                claims.addClaim("family_name", familyName);
                claims.addClaim("preferred_username", member.getUsername());
            }
            if (scopes.contains(Scope.EMAIL) && member != null) {
                claims.addClaim("email", member.getEmail());
            }
        }
        catch (QueryFailedException ex) {
            tr.abort();
        }
        finally {
            try {
                tr.commit();
            }
            catch (CommitTransactionException e) {
                LOGGER.error("Unable to provide open ID claims", (Throwable)e);
            }
        }
        return claims;
    }
}

