/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.model;

import com.pageseeder.base.oauth.core.OAuthException;
import com.pageseeder.base.oauth.model.AccessToken;
import com.pageseeder.base.oauth.model.MemoryTokenStorage;
import com.pageseeder.common.oauth.Passwords;
import com.pageseeder.common.util.BinaryFormat;
import com.pageseeder.db.oauth.Client;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.Nullable;

public final class AccessTokenManager {
    private static final int MAX_CAPACITY = 1000000;
    private final MemoryTokenStorage<AccessToken> storage = new MemoryTokenStorage(1000000, 30L, TimeUnit.MINUTES);
    private static final int ENTROPY_BYTES = 24;
    private static final AccessTokenManager SINGLETON = new AccessTokenManager();

    private AccessTokenManager() {
    }

    public static AccessTokenManager singleton() {
        return SINGLETON;
    }

    public AccessToken issue(Client client, long memberId, String scope) throws OAuthException {
        String clientId = client.getIdentifier();
        OffsetDateTime now = OffsetDateTime.now();
        OffsetDateTime expires = now.plus(client.getAccessTokenMaxAge(TimeUnit.MILLISECONDS), ChronoUnit.MILLIS);
        String code = Passwords.randomBytes((int)24, (BinaryFormat)BinaryFormat.BASE_64_URL);
        AccessToken t = new AccessToken(code, now, expires, clientId, memberId, scope);
        this.storage.store(t);
        client.updateLastToken();
        return t;
    }

    public AccessToken issueInternal(String clientId, long memberId, long maxAgeHours) throws OAuthException {
        OffsetDateTime now = OffsetDateTime.now();
        OffsetDateTime expires = now.plusHours(maxAgeHours);
        String code = Passwords.randomBytes((int)24, (BinaryFormat)BinaryFormat.BASE_64_URL);
        AccessToken t = new AccessToken(code, now, expires, clientId, memberId, "all");
        this.storage.store(t);
        return t;
    }

    public @Nullable AccessToken get(String token) {
        return this.storage.get(token);
    }

    public @Nullable AccessToken getIfMatch(String token, @Nullable String clientId) {
        AccessToken t = this.get(token);
        if (t == null || t.hasExpired()) {
            return null;
        }
        if (clientId == null || !clientId.equals(t.getClientId())) {
            return null;
        }
        return t;
    }

    public @Nullable OffsetDateTime getLastPurged() {
        return this.storage.getLastPurged();
    }

    public int getTotalTokens() {
        return this.storage.size();
    }

    public List<AccessToken> listTokens(int from, int to) {
        return this.storage.tokens(from, to);
    }

    public Collection<AccessToken> listTokens() {
        return Collections.unmodifiableCollection(this.storage.tokens());
    }

    public @Nullable AccessToken revoke(String token) {
        return this.storage.remove(token);
    }

    public @Nullable AccessToken revoke(String maskedToken, String clientId, long memberId) {
        String start = maskedToken.substring(0, maskedToken.indexOf(42));
        String end = maskedToken.substring(maskedToken.lastIndexOf(42) + 1);
        if (start.length() + end.length() < 8) {
            return null;
        }
        return this.storage.remove(start, end, clientId, memberId);
    }

    public int purge() {
        return this.storage.purge();
    }

    public int revokeForClient(String clientId) {
        return this.storage.removeForClient(clientId);
    }

    public int revokeForMember(long memberId) {
        return this.storage.removeForMember(memberId);
    }

    public List<AccessToken> listTokensByClient(String clientId) {
        ArrayList<AccessToken> tokens = new ArrayList<AccessToken>();
        for (AccessToken t : this.storage.tokens()) {
            if (!t.getClientId().equals(clientId)) continue;
            tokens.add(t);
        }
        return tokens;
    }

    public List<AccessToken> listTokensByMember(long memberId) {
        ArrayList<AccessToken> tokens = new ArrayList<AccessToken>();
        for (AccessToken t : this.storage.tokens()) {
            if (memberId != t.getMemberId()) continue;
            tokens.add(t);
        }
        return tokens;
    }

    public void destroy() {
        this.storage.destroy();
    }
}

