/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.core;

import com.pageseeder.base.oauth.core.OAuthErrorType;
import com.pageseeder.base.oauth.core.OAuthException;
import com.pageseeder.base.oauth.core.OAuthParameter;
import com.pageseeder.base.oauth.core.OAuthRequest;
import com.pageseeder.common.oauth.HTTP;
import com.pageseeder.common.util.Strings;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class OAuthRequestValidator {
    private final List<Constraint> constraints = new ArrayList<Constraint>(4);

    public OAuthRequestValidator() {
    }

    public OAuthRequestValidator(Constraint constraint) {
        this.constraints.add(constraint);
    }

    public OAuthRequestValidator(List<Constraint> constraints) {
        this.constraints.addAll(constraints);
    }

    public static OAuthRequestValidator create() {
        return new OAuthRequestValidator();
    }

    public void validate(OAuthRequest req) throws OAuthException {
        try {
            for (Constraint c : this.constraints) {
                c.validate(req);
            }
        }
        catch (OAuthException ex) {
            String redirectUri = req.getParameter(OAuthParameter.redirect_uri);
            if (!Strings.isEmpty((String)redirectUri)) {
                ex.setRedirectURI(redirectUri);
            }
            throw ex;
        }
    }

    public OAuthRequestValidator requires(OAuthParameter ... required) {
        for (OAuthParameter name : required) {
            this.constraints.add(new RequiredParameter(name));
        }
        return this;
    }

    public OAuthRequestValidator matches(OAuthParameter parameter, String regex) {
        this.constraints.add(new ParameterRegexMatch(parameter, regex));
        return this;
    }

    public OAuthRequestValidator isAuthenticated() {
        this.constraints.add(new Authenticated());
        return this;
    }

    public OAuthRequestValidator acceptsMethod(String ... methods) {
        this.constraints.add(new AcceptedMethods(methods));
        return this;
    }

    public OAuthRequestValidator with(Class<? extends Constraint> kindOfConstraint) {
        ArrayList<Constraint> constraintList = new ArrayList<Constraint>(this.constraints);
        try {
            Constraint constraint = kindOfConstraint.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            constraintList.add(constraint);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IllegalArgumentException(ex);
        }
        return new OAuthRequestValidator(constraintList);
    }

    public static final class AcceptedMethods
    implements Constraint {
        private final String[] accepted;

        public AcceptedMethods(String ... method) {
            this.accepted = method;
        }

        @Override
        public void validate(OAuthRequest req) throws OAuthException {
            String method = req.getMethod();
            for (String m : this.accepted) {
                if (!m.equals(method)) continue;
                return;
            }
            throw OAuthException.error(OAuthErrorType.invalid_request).description("Method not correct.");
        }
    }

    public static final class RequiresClientCredentials
    implements Constraint {
        @Override
        public void validate(OAuthRequest req) throws OAuthException {
            EnumSet<OAuthParameter> missingParameters = EnumSet.noneOf(OAuthParameter.class);
            String authorization = req.getAuthorizationHeader();
            HTTP.BasicCredentials credentials = HTTP.getBasicCredentials((String)authorization);
            if (credentials == null || Strings.isEmpty((String)credentials.username()) || Strings.isEmpty((String)credentials.password())) {
                if (Strings.isEmpty((String)req.getParameter(OAuthParameter.client_id))) {
                    missingParameters.add(OAuthParameter.client_id);
                }
                if (Strings.isEmpty((String)req.getParameter(OAuthParameter.client_secret))) {
                    missingParameters.add(OAuthParameter.client_secret);
                }
            }
            if (!missingParameters.isEmpty()) {
                throw OAuthException.handleMissingParameters(missingParameters);
            }
        }
    }

    public static final class ParameterRegexMatch
    implements Constraint {
        private final OAuthParameter parameter;
        private final Pattern pattern;

        public ParameterRegexMatch(OAuthParameter parameter, String regex) {
            this.parameter = Objects.requireNonNull(parameter);
            Objects.requireNonNull(regex);
            if (regex.isEmpty()) {
                throw new IllegalArgumentException();
            }
            try {
                this.pattern = Pattern.compile(regex);
            }
            catch (PatternSyntaxException ex) {
                throw new IllegalArgumentException("Invalid pattern", ex);
            }
        }

        @Override
        public void validate(OAuthRequest req) throws OAuthException {
            String value = req.getParameter(this.parameter);
            if (value == null) {
                return;
            }
            if (!this.pattern.matcher(value).matches()) {
                // empty if block
            }
        }
    }

    public static final class RequiredContentType
    implements Constraint {
        private final String required;

        public RequiredContentType(String required) {
            this.required = Objects.requireNonNull(required);
        }

        @Override
        public void validate(OAuthRequest req) throws OAuthException {
            String contentType = req.getContentType();
            if (!this.hasContentType(contentType)) {
                String message = "Bad request content type. Expecting: " + this.required;
                throw OAuthException.error(OAuthErrorType.invalid_request).description(message);
            }
        }

        private boolean hasContentType(String contentType) {
            if (Strings.isEmpty((String)contentType)) {
                return false;
            }
            StringTokenizer tokenizer = new StringTokenizer(contentType, ";");
            while (tokenizer.hasMoreTokens()) {
                if (!this.required.equals(tokenizer.nextToken())) continue;
                return true;
            }
            return false;
        }
    }

    public static final class Authenticated
    implements Constraint {
        @Override
        public void validate(OAuthRequest req) throws OAuthException {
        }
    }

    public static final class RequiredParameter
    implements Constraint {
        private final OAuthParameter parameter;

        public RequiredParameter(OAuthParameter parameter) {
            this.parameter = Objects.requireNonNull(parameter);
        }

        @Override
        public void validate(OAuthRequest req) throws OAuthException {
            String value = req.getParameter(this.parameter);
            if (Strings.isEmpty((String)value)) {
                throw OAuthException.error(OAuthErrorType.invalid_request).description("Missing " + this.parameter.name() + " parameter value");
            }
        }
    }

    public static interface Constraint {
        public void validate(OAuthRequest var1) throws OAuthException;
    }
}

