/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mfa.webauthn;

import com.pageseeder.base.mfa.core.ChallengeData;
import com.pageseeder.base.serial.OutputPrinter;
import com.yubico.webauthn.data.AuthenticatorSelectionCriteria;
import com.yubico.webauthn.data.AuthenticatorTransport;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredentialCreationOptions;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import com.yubico.webauthn.data.PublicKeyCredentialParameters;
import com.yubico.webauthn.data.RelyingPartyIdentity;
import com.yubico.webauthn.data.UserIdentity;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class PublicKeyCreation
implements ChallengeData {
    private final PublicKeyCredentialCreationOptions options;
    private final String[] hints;

    public PublicKeyCreation(PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions, String[] hints) {
        this.options = publicKeyCredentialCreationOptions;
        this.hints = hints;
    }

    @Override
    public boolean isSecret() {
        return false;
    }

    public PublicKeyCredentialCreationOptions getPublicKeyCredentialCreationOptions() {
        return this.options;
    }

    @Override
    public void print(OutputPrinter out) {
        Optional selectionCriteria;
        out.startObject("creation-options");
        ByteArray challenge = this.options.getChallenge();
        out.field("challenge", challenge.getBase64Url());
        this.options.getTimeout().ifPresent(timeout -> out.field("timeout", (long)timeout));
        if (this.hints.length > 0) {
            out.field("hints", this.hints);
        }
        RelyingPartyIdentity rp = this.options.getRp();
        out.startObject("rp");
        out.field("name", rp.getName());
        out.field("id", rp.getId());
        out.endObject();
        UserIdentity userIdentity = this.options.getUser();
        out.startObject("user");
        out.field("id", userIdentity.getId().getBase64Url());
        out.field("name", userIdentity.getName());
        out.field("displayName", userIdentity.getDisplayName());
        out.endObject();
        List params = this.options.getPubKeyCredParams();
        out.startCollection("pubKeyCredParams");
        for (PublicKeyCredentialParameters p : params) {
            out.startObject("pubKeyCredParam");
            out.field("type", p.getType().getId());
            out.field("alg", p.getAlg().getId());
            out.endObject();
        }
        out.endCollection();
        Optional excludedCredentials = this.options.getExcludeCredentials();
        if (excludedCredentials.isPresent()) {
            out.startCollection("excludedCredentials");
            Set excluded = (Set)excludedCredentials.get();
            for (PublicKeyCredentialDescriptor d : excluded) {
                out.startObject("excludedCredential");
                out.field("id", d.getId().getBase64Url());
                out.field("type", d.getType().getId());
                d.getTransports().ifPresent(transports -> out.field("transports", (String[])transports.stream().map(AuthenticatorTransport::getId).toArray(String[]::new)));
                out.endObject();
            }
            out.endCollection();
        }
        if ((selectionCriteria = this.options.getAuthenticatorSelection()).isPresent()) {
            AuthenticatorSelectionCriteria criteria = (AuthenticatorSelectionCriteria)selectionCriteria.get();
            out.startObject("authenticatorSelection");
            criteria.getUserVerification().ifPresent(userVerificationRequirement -> out.field("userVerification", userVerificationRequirement.getValue()));
            criteria.getAuthenticatorAttachment().ifPresent(authenticatorAttachment -> out.field("authenticatorAttachment", authenticatorAttachment.getValue()));
            criteria.getResidentKey().ifPresent(residentKeyRequirement -> out.field("residentKey", residentKeyRequirement.getValue()));
            out.endObject();
        }
        out.endObject();
    }
}

