/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mfa.core;

import com.pageseeder.base.mfa.core.ChallengeData;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.common.oauth.Passwords;
import java.io.Serializable;
import java.util.Objects;

public final class VerificationCode
implements ChallengeData,
Serializable,
UniversallyPrintable {
    private static final long serialVersionUID = 20241205L;
    private final String code;

    private VerificationCode(String code) {
        this.code = Objects.requireNonNull(code);
    }

    public static VerificationCode newCode(int length, CodeType type) {
        Object chars = "123456789";
        chars = type == CodeType.ALPHA_NUMERIC ? (String)chars + "ABCDEFGHJKLMNPQRSTUVWXYZ" : (String)chars + "0";
        String code = Passwords.random((int)length, (char[])((String)chars).toCharArray());
        return new VerificationCode(code);
    }

    @Override
    public boolean isSecret() {
        return true;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerificationCode that = (VerificationCode)o;
        return Objects.equals(this.code, that.code);
    }

    public int hashCode() {
        return Objects.hashCode(this.code);
    }

    public String code() {
        return this.code;
    }

    @Override
    public void print(OutputPrinter out) {
        out.startObject("verification-code");
        out.endObject();
    }

    public static enum CodeType {
        DIGITS_ONLY,
        ALPHA_NUMERIC;

    }
}

