/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mfa.core;

import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.mfa.core.Challenge;
import com.pageseeder.base.mfa.core.ChallengeManager;
import com.pageseeder.base.mfa.core.ChallengeResult;
import com.pageseeder.db.model.Authenticator;

public interface ChallengeVerifier {
    default public ChallengeResult verifyChallenge(Authenticator authenticator, String challengeId, String response) {
        ChallengeManager manager = ChallengeManager.singleton();
        Challenge challenge = manager.get(challengeId);
        if (challenge == null) {
            SecurityLog.warn(SecurityLog.EventType.AUTHENTICATION, "Challenge does not exist:", challengeId);
            return ChallengeResult.INVALID_CHALLENGE;
        }
        if (!challenge.matchAuthenticator(authenticator)) {
            SecurityLog.warn(SecurityLog.EventType.AUTHENTICATION, "Challenge does not match authenticator");
            return ChallengeResult.INVALID_CHALLENGE;
        }
        return this.verifyChallenge(authenticator, challenge, response);
    }

    public ChallengeResult verifyChallenge(Authenticator var1, Challenge var2, String var3);
}

