/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mfa.core;

import com.pageseeder.base.mfa.core.Challenge;
import java.io.Serializable;
import org.eclipse.jdt.annotation.Nullable;

public final class ChallengeRequest
implements Serializable {
    private final Status status;
    private final @Nullable Challenge challenge;

    public ChallengeRequest(Status status) {
        this.status = status;
        this.challenge = null;
    }

    public ChallengeRequest(Status status, @Nullable Challenge challenge) {
        this.status = status;
        this.challenge = challenge;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getStatusId() {
        return this.status.id();
    }

    public @Nullable Challenge getChallenge() {
        return this.challenge;
    }

    public boolean isSuccessful() {
        return this.status.successful;
    }

    public String getMessage() {
        return this.status.message;
    }

    public static ChallengeRequest rateLimitReached() {
        return new ChallengeRequest(Status.RATE_LIMIT_REACHED);
    }

    public static ChallengeRequest ready(Challenge challenge) {
        return new ChallengeRequest(Status.READY, challenge);
    }

    public static ChallengeRequest emailSent(Challenge challenge) {
        return new ChallengeRequest(Status.EMAIL_SENT, challenge);
    }

    public static ChallengeRequest smsSent(Challenge challenge) {
        return new ChallengeRequest(Status.SMS_SENT, challenge);
    }

    public static ChallengeRequest error() {
        return new ChallengeRequest(Status.ERROR);
    }

    public static ChallengeRequest publicKey(Challenge challenge) {
        return new ChallengeRequest(Status.PUBLIC_KEY_REQUESTED, challenge);
    }

    public static enum Status {
        ERROR(false, "Unable to create challenge"),
        READY(true, "Ready for response"),
        EMAIL_SENT(true, "OTP sent to registered email address"),
        SMS_SENT(true, "OTP sent to registered phone number"),
        RATE_LIMIT_REACHED(false, "Too many challenges"),
        PUBLIC_KEY_REQUESTED(true, "Public key credentials options provided");

        private final boolean successful;
        private final String message;

        private Status(boolean successful, String message) {
            this.successful = successful;
            this.message = message;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public String id() {
            return this.name().toLowerCase().replace('_', '-');
        }

        public String getMessage() {
            return this.message;
        }
    }
}

