/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.logback;

import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.web.UserAgent;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class SecurityEvent
implements XMLWritable {
    private static final int MIN_LINE_SIZE = 38;
    private static final Pattern VALID_LINE = Pattern.compile("(?<datetime>\\S+\\.\\d{3}) (?<level>\\S{4,5}) \\s?(?<method>\\S{3,8}) (?<path>\\S+) (?<ip>\\S+) (?<type>\\S+) (?<member>\\S*):(?<username>\\S+) (?:\"(?<ua>[^\"]+)\")? - (.+)");
    private String datetime;
    private String level;
    private String method = "GET";
    private String path = "/";
    private String ip = "0.0.0.0";
    private SecurityLog.EventType eventType = SecurityLog.EventType.OTHER;
    private String member = "";
    private String username = "anonymous";
    private String userAgent = "";
    private String message;

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("event");
        xml.attribute("datetime", this.datetime);
        xml.attribute("level", this.level);
        xml.attribute("method", this.method);
        xml.attribute("path", this.path);
        xml.attribute("ip", this.ip);
        xml.attribute("type", this.eventType.id());
        xml.attribute("member", this.member);
        xml.attribute("username", this.username);
        xml.attribute("message", this.message);
        xml.attribute("user-agent", this.userAgent);
        UserAgent ua = UserAgent.fromString(this.userAgent);
        xml.attribute("browser", ua.getBrowser());
        xml.attribute("browser-type", ua.getBrowserType());
        xml.attribute("browser-version", ua.getBrowserMajorVersion());
        xml.attribute("device-type", ua.getDeviceType());
        xml.attribute("platform", ua.getPlatform());
        xml.attribute("platform-version", ua.getPlatformVersion());
        xml.closeElement();
    }

    public SecurityLog.EventType getEventType() {
        return this.eventType;
    }

    public String getLevel() {
        return this.level;
    }

    public static @Nullable SecurityEvent parse(@Nullable String line) {
        if (line == null || line.length() < 38) {
            return null;
        }
        Matcher m = VALID_LINE.matcher(line);
        SecurityEvent event = null;
        if (m.matches()) {
            event = new SecurityEvent();
            event.datetime = m.group("datetime");
            event.level = m.group("level");
            event.method = m.group("method");
            event.path = m.group("path");
            event.ip = m.group("ip");
            event.eventType = SecurityLog.EventType.fromId(m.group("type"));
            event.member = m.group("member");
            event.username = m.group("username");
            event.userAgent = m.group("ua");
            event.message = m.group(10);
        }
        return event;
    }
}

