/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class RecentLogFilter
extends Filter<ILoggingEvent> {
    private static final int MAX_HOLD_SIZE = 100;
    private static final Queue<ILoggingEvent> RECENT = new ConcurrentLinkedQueue<ILoggingEvent>();

    public FilterReply decide(ILoggingEvent event) {
        RECENT.add(event);
        if (RECENT.size() > 100) {
            RECENT.remove();
        }
        return FilterReply.NEUTRAL;
    }

    public static void clearAll() {
        RECENT.clear();
    }

    static synchronized List<ILoggingEvent> getCopyOfEvents() {
        return new ArrayList<ILoggingEvent>(RECENT);
    }
}

