/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.logback;

import com.pageseeder.common.util.ISO8601;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Date;
import java.util.Objects;

public final class DailyLogFileFilter
implements FilenameFilter {
    private final boolean isToday;
    private final String date;
    private final String extension;

    public DailyLogFileFilter(Date date, String extension) {
        String iso;
        Objects.requireNonNull(date);
        this.date = iso = ISO8601.CALENDAR_DATE.format(date.getTime());
        this.isToday = iso.equals(ISO8601.today());
        this.extension = extension;
    }

    @Override
    public boolean accept(File dir, String name) {
        if (!name.endsWith(this.extension)) {
            return false;
        }
        boolean include = name.contains(this.date);
        if (!include && this.isToday) {
            include = name.indexOf(45) == -1;
        }
        return include;
    }
}

