/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.document;

import com.pageseeder.base.document.TransclusionHandler;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Publication;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.jdt.annotation.Nullable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class PSMLTransclusionResolver {
    public final boolean hasTransclusions(String content) {
        return content.contains(" type=\"transclude\"") || content.contains(" type=\"math\"");
    }

    public final void resolveTransclusions(Reader content, Writer out, Database db, UserDetails userDetails, @Nullable String version, @Nullable Publication pub) throws IOException {
        try {
            XMLReader reader = XMLHelpers.safeXMLReader();
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            reader.setContentHandler(new TransclusionHandler(db, userDetails, out, version, pub));
            reader.parse(new InputSource(content));
        }
        catch (SAXException ex) {
            throw new IOException("Failed to read XML input", ex);
        }
        finally {
            content.close();
        }
    }
}

