/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.document;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.DocumentConfigHandler;
import com.pageseeder.base.label.LabelConfig;
import com.pageseeder.base.label.LabelInfo;
import com.pageseeder.base.label.LabelType;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.common.io.Locations;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.io.TemplateZone;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.model.Role;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.template.Template;
import org.pageseeder.psml.template.TemplateException;
import org.pageseeder.psml.template.TemplateFactory;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;

public final class PSMLFiles {
    public static final String PSML_FOLDER = "psml";
    public static final String DOCUMENT_FOLDER = "document";
    public static final String PUBLICATION_FOLDER = "publication";
    public static final String DEFAULT_FOLDER = "default";
    public static final String DEFAULT_DOCTYPE = "default";
    public static final String MEDIA_TEMPLATE = "media-template.psml";
    public static final String DOCUMENT_TEMPLATE = "document-template.psml";
    public static final String DOCUMENT_CONFIG = "document-config.xml";
    public static final String PUBLICATION_CONFIG = "publication-config.xml";
    public static final String PUBLISH_CONFIG = "publish-config.xml";
    public static final String SCHEDULE_CONFIG = "schedule-config.xml";
    public static final String PUBLISH_FOLDER = "publish";
    public static final String XREF_CONFIG = "xref-config.xml";
    public static final String EDITOR_CONFIG = "editor-config.xml";
    public static final String WORD_EXPORT_TEMPLATE = "word-export-template.docx";
    public static final String WORD_EXPORT_TEMPLATE_PATH = "/export/word-export-template.docx";
    public static final String WORD_IMPORT_CONFIG = "word-import-config.xml";
    public static final String PSML_SPLIT_CONFIG = "psml-split-config.xml";
    public static final String WORD_EXPORT_CONFIG = "word-export-config.xml";
    public static final String WORD_EXPORT_CONFIG_PATH = "/export/word-export-config.xml";
    public static final String PDF_EXPORT_CONFIG = "pdf-export-config.xml";
    public static final String PDF_EXPORT_CONFIG_PATH = "/export/pdf-export-config.xml";

    public static Set<String> listAvailableTypes(@Nullable String template, String folder) {
        com.pageseeder.common.io.Template kit;
        File dir;
        String globalTemplate;
        com.pageseeder.common.io.Template kit2;
        File dir2;
        HashSet<String> types = new HashSet<String>();
        File webapp = new File(Settings.getContextPath());
        TypeCollector collector = new TypeCollector(types);
        if (!Strings.isEmpty((String)template) && (dir2 = TemplateFiles.get((com.pageseeder.common.io.Template)(kit2 = new com.pageseeder.common.io.Template(template)), (TemplateZone)TemplateFiles.Zone.TEMPLATE, (File)webapp, (String)folder)).exists()) {
            dir2.listFiles(collector);
        }
        if (!Strings.isEmpty((String)(globalTemplate = GlobalSettings.getGlobalTemplate())) && (dir = TemplateFiles.get((com.pageseeder.common.io.Template)(kit = new com.pageseeder.common.io.Template(globalTemplate)), (TemplateZone)TemplateFiles.Zone.TEMPLATE, (File)webapp, (String)folder)).exists()) {
            dir.listFiles(collector);
        }
        if ((dir = TemplateFiles.get((com.pageseeder.common.io.Template)(kit = com.pageseeder.common.io.Template.DEFAULT), (TemplateZone)TemplateFiles.Zone.TEMPLATE, (File)webapp, (String)folder)).exists()) {
            dir.listFiles(collector);
        }
        return types;
    }

    public static Set<String> listDefinedBy(String template, String path) {
        com.pageseeder.common.io.Template kit;
        File dir;
        String globalTemplate;
        com.pageseeder.common.io.Template kit2;
        File dir2;
        HashSet<String> templates = new HashSet<String>();
        File webapp = new File(Settings.getContextPath());
        if (!Strings.isEmpty((String)template) && (dir2 = TemplateFiles.get((com.pageseeder.common.io.Template)(kit2 = new com.pageseeder.common.io.Template(template)), (TemplateZone)TemplateFiles.Zone.TEMPLATE, (File)webapp, (String)path)).exists()) {
            templates.add(template);
        }
        if (!Strings.isEmpty((String)(globalTemplate = GlobalSettings.getGlobalTemplate())) && (dir = TemplateFiles.get((com.pageseeder.common.io.Template)(kit = new com.pageseeder.common.io.Template(globalTemplate)), (TemplateZone)TemplateFiles.Zone.TEMPLATE, (File)webapp, (String)path)).exists()) {
            templates.add(globalTemplate);
        }
        if ((dir = TemplateFiles.get((com.pageseeder.common.io.Template)(kit = com.pageseeder.common.io.Template.DEFAULT), (TemplateZone)TemplateFiles.Zone.TEMPLATE, (File)webapp, (String)path)).exists()) {
            templates.add("default");
        }
        return templates;
    }

    public static String findCSS(String template, @Nullable String type) {
        File webapp = new File(Settings.getContextPath());
        String folder = type == null ? "default" : type;
        String filepath = PSML_FOLDER + File.separator + folder + File.separator + "style" + File.separator + "document.css";
        String webpath = PSML_FOLDER + File.separator + folder + File.separator + "document.css";
        com.pageseeder.common.io.Template kit = new com.pageseeder.common.io.Template(template);
        File cssfile = TemplateFiles.get((com.pageseeder.common.io.Template)kit, (TemplateZone)TemplateFiles.Zone.TEMPLATE, (File)webapp, (String)filepath);
        File css = TemplateFiles.get((com.pageseeder.common.io.Template)kit, (TemplateZone)TemplateFiles.Zone.WEB, (File)webapp, (String)webpath);
        if (!cssfile.exists()) {
            String globalTemplate = GlobalSettings.getGlobalTemplate();
            if (!Strings.isEmpty((String)globalTemplate)) {
                kit = new com.pageseeder.common.io.Template(globalTemplate);
                cssfile = TemplateFiles.get((com.pageseeder.common.io.Template)kit, (TemplateZone)TemplateFiles.Zone.TEMPLATE, (File)webapp, (String)filepath);
                css = TemplateFiles.get((com.pageseeder.common.io.Template)kit, (TemplateZone)TemplateFiles.Zone.WEB, (File)webapp, (String)webpath);
            }
            if (!cssfile.exists()) {
                css = TemplateFiles.get((com.pageseeder.common.io.Template)com.pageseeder.common.io.Template.DEFAULT, (TemplateZone)TemplateFiles.Zone.WEB, (File)webapp, (String)"document/css/psml-content.css");
            }
        }
        return Locations.toLocation((File)webapp, (File)css);
    }

    public static @Nullable File findExtensionMediaTemplate(String template, String extension) {
        TemplateFiles resources = new TemplateFiles(template);
        return resources.findFile(DOCUMENT_FOLDER + File.separator + extension + File.separator + MEDIA_TEMPLATE);
    }

    public static @Nullable File findDocumentTemplate(String template, String doctype) {
        String documenttype = Strings.isEmpty((String)doctype) ? "default" : doctype;
        TemplateFiles resources = new TemplateFiles(template);
        return resources.findFile(PSML_FOLDER + File.separator + documenttype + File.separator + DOCUMENT_TEMPLATE);
    }

    public static @Nullable Template findFragmentTemplate(String template, String doctype, String fragmentType) throws IOException, TemplateException {
        if (Strings.isEmpty((String)fragmentType)) {
            return null;
        }
        File config = PSMLFiles.findDocumentTemplate(template, doctype);
        if (config == null || !config.exists()) {
            return null;
        }
        TemplateFactory factory = new TemplateFactory(StandardCharsets.UTF_8);
        factory.setFragment(fragmentType);
        return factory.parse(config);
    }

    public static String findDocumentConfig(String template, String doctype, LabelConfig projectLabels, Role role) throws FoundationException {
        String documentType = Strings.isEmpty((String)doctype) ? "default" : doctype;
        TemplateFiles resources = new TemplateFiles(com.pageseeder.common.io.Template.DEFAULT);
        File defaultConfig = resources.findFile(PSML_FOLDER + File.separator + "default" + File.separator + DOCUMENT_CONFIG);
        DocumentConfigHandler handler = new DocumentConfigHandler(projectLabels, documentType);
        PSMLFiles.parseDocumentConfig(defaultConfig, handler);
        resources = new TemplateFiles(template);
        File cfg = resources.findFile(PSML_FOLDER + File.separator + documentType + File.separator + DOCUMENT_CONFIG);
        if (!defaultConfig.equals(cfg)) {
            handler.startDocument();
            PSMLFiles.parseDocumentConfig(cfg, handler);
        }
        XMLStringWriter xml = new XMLStringWriter(XML.NamespaceAware.No);
        try {
            handler.toXML((XMLWriter)xml, role);
        }
        catch (IOException ex) {
            throw new FoundationException("Failed to create XML document config: " + ex.getMessage(), ex);
        }
        return xml.toString();
    }

    public static @Nullable String findCreationConfig(String template, String documentType) throws FoundationException {
        String creation = null;
        DocumentConfigHandler handler = new DocumentConfigHandler();
        TemplateFiles resources = new TemplateFiles(template);
        File cfg = resources.findFile(PSML_FOLDER + File.separator + documentType + File.separator + DOCUMENT_CONFIG);
        if (PSMLFiles.parseDocumentConfig(cfg, handler) && handler.creationWasFound()) {
            creation = handler.getCreation();
        }
        if (creation == null && PSMLFiles.parseDocumentConfig(cfg = (resources = new TemplateFiles(com.pageseeder.common.io.Template.DEFAULT)).findFile(PSML_FOLDER + File.separator + documentType + File.separator + DOCUMENT_CONFIG), handler) && creation == null && handler.creationWasFound()) {
            creation = handler.getCreation();
        }
        if (creation == null) {
            return null;
        }
        XMLStringWriter xml = new XMLStringWriter(XML.NamespaceAware.No);
        try {
            xml.openElement("document-config");
            xml.attribute("type", documentType);
            xml.writeXML(creation);
            xml.closeElement();
        }
        catch (IOException ex) {
            throw new FoundationException("Failed to create XML ouptut: " + ex.getMessage(), ex);
        }
        return xml.toString();
    }

    public static LabelConfig findLabelingConfig(String template, String documentType, LabelConfig projectLabels) throws FoundationException {
        LabelConfig labeling = null;
        boolean overrideLabels = false;
        DocumentConfigHandler handler = new DocumentConfigHandler();
        TemplateFiles resources = new TemplateFiles(new com.pageseeder.common.io.Template(template));
        File config = resources.findFile(PSML_FOLDER + File.separator + documentType + File.separator + DOCUMENT_CONFIG);
        if (PSMLFiles.parseDocumentConfig(config, handler) && handler.getLabelConfig() != null) {
            labeling = handler.getLabelConfig();
            overrideLabels = handler.overrideLabeling();
        }
        if (labeling == null && PSMLFiles.parseDocumentConfig(config = (resources = new TemplateFiles(com.pageseeder.common.io.Template.DEFAULT)).findFile(PSML_FOLDER + File.separator + documentType + File.separator + DOCUMENT_CONFIG), handler) && handler.getLabelConfig() != null) {
            labeling = handler.getLabelConfig();
        }
        if (labeling != null && !overrideLabels && projectLabels != null) {
            LabelConfig cfg = projectLabels;
            for (LabelType type : labeling.getTypes()) {
                List<LabelInfo> labels = labeling.getLabelInfos(type);
                if (labels == null) continue;
                for (LabelInfo label : labels) {
                    cfg.add(type, label);
                }
            }
            labeling = cfg;
        }
        return labeling;
    }

    public static String findDocumentPublishConfig(String template, String doctype, String actionTypes, String sourceTypes, boolean includeDefault, Role role, DocumentConfigHandler handler) throws FoundationException {
        String documentType = Strings.isEmpty((String)doctype) ? "default" : doctype;
        File webapp = new File(Settings.getContextPath());
        String project = null;
        String path = PSML_FOLDER + File.separator + documentType + File.separator + DOCUMENT_CONFIG;
        com.pageseeder.common.io.Template kit = new com.pageseeder.common.io.Template(template);
        File config = TemplateFiles.get((com.pageseeder.common.io.Template)kit, (TemplateZone)TemplateFiles.Zone.TEMPLATE, (File)webapp, (String)path);
        PSMLFiles.parseDocumentConfig(config, handler);
        project = config.getParentFile().getParentFile().getParentFile().getName();
        String globalTemplate = GlobalSettings.getGlobalTemplate();
        DocumentConfigHandler customHandler = new DocumentConfigHandler(null, doctype, handler.overrideTargets());
        String customProject = null;
        if (!(Strings.isEmpty((String)globalTemplate) || handler.overridePublishing() || globalTemplate.equals(template))) {
            kit = new com.pageseeder.common.io.Template(globalTemplate);
            config = TemplateFiles.get((com.pageseeder.common.io.Template)kit, (TemplateZone)TemplateFiles.Zone.TEMPLATE, (File)webapp, (String)path);
            PSMLFiles.parseDocumentConfig(config, customHandler);
            customProject = config.getParentFile().getParentFile().getParentFile().getName();
        }
        DocumentConfigHandler defaultHandler = new DocumentConfigHandler(null, "default", customHandler.overrideTargets());
        if (!handler.overridePublishing() && (includeDefault || "default".equals(doctype))) {
            kit = com.pageseeder.common.io.Template.DEFAULT;
            config = TemplateFiles.get((com.pageseeder.common.io.Template)kit, (TemplateZone)TemplateFiles.Zone.TEMPLATE, (File)webapp, (String)path);
            PSMLFiles.parseDocumentConfig(config, defaultHandler);
        }
        handler.setOverrideTargets(defaultHandler.overrideTargets());
        return PSMLFiles.outputPublishActions(handler, project, customHandler, customProject, defaultHandler, actionTypes, sourceTypes, null, null, role);
    }

    public static String findGroupPublishConfig(String template, String actiontypes, String sourcetypes, String extension, String doctype, Role role, List<String> overridetargets) throws FoundationException {
        File webapp = new File(Settings.getContextPath());
        DocumentConfigHandler handler = new DocumentConfigHandler(overridetargets);
        String project = null;
        String path = PUBLISH_FOLDER + File.separator + PUBLISH_CONFIG;
        com.pageseeder.common.io.Template kit = new com.pageseeder.common.io.Template(template);
        File config = TemplateFiles.get((com.pageseeder.common.io.Template)kit, (TemplateZone)TemplateFiles.Zone.TEMPLATE, (File)webapp, (String)path);
        PSMLFiles.parseDocumentConfig(config, handler);
        project = config.getParentFile().getParentFile().getName();
        String globalTemplate = GlobalSettings.getGlobalTemplate();
        DocumentConfigHandler customHandler = new DocumentConfigHandler(handler.overrideTargets());
        String customProject = null;
        if (!(Strings.isEmpty((String)globalTemplate) || handler.overridePublishing() || globalTemplate.equals(template))) {
            kit = new com.pageseeder.common.io.Template(globalTemplate);
            config = TemplateFiles.get((com.pageseeder.common.io.Template)kit, (TemplateZone)TemplateFiles.Zone.TEMPLATE, (File)webapp, (String)path);
            PSMLFiles.parseDocumentConfig(config, customHandler);
            customProject = config.getParentFile().getParentFile().getName();
        }
        DocumentConfigHandler defaultHandler = new DocumentConfigHandler(customHandler.overrideTargets());
        if (!handler.overridePublishing()) {
            kit = com.pageseeder.common.io.Template.DEFAULT;
            config = TemplateFiles.get((com.pageseeder.common.io.Template)kit, (TemplateZone)TemplateFiles.Zone.TEMPLATE, (File)webapp, (String)path);
            PSMLFiles.parseDocumentConfig(config, defaultHandler);
        }
        return PSMLFiles.outputPublishActions(handler, project, customHandler, customProject, defaultHandler, actiontypes, sourcetypes, extension, doctype, role);
    }

    public static @Nullable File findPublicationConfigFile(String template, String type) {
        com.pageseeder.common.io.Template kit = new com.pageseeder.common.io.Template(template);
        File webapp = new File(Settings.getContextPath());
        File config = TemplateFiles.get((com.pageseeder.common.io.Template)kit, (TemplateZone)TemplateFiles.Zone.TEMPLATE, (File)webapp, (String)(PUBLICATION_FOLDER + File.separator + type + File.separator + PUBLICATION_CONFIG));
        return config.exists() ? config : null;
    }

    private static boolean parseDocumentConfig(@Nullable File config, DocumentConfigHandler handler) throws FoundationException {
        if (config != null && config.exists() && config.isFile()) {
            ArrayList<String> errors = new ArrayList<String>();
            try (FileInputStream in = new FileInputStream(config);){
                XMLHelpers.parse(in, handler, errors, null);
            }
            catch (FileNotFoundException ex) {
                throw new FoundationException("Failed to load document config: " + ex.getMessage());
            }
            catch (IOException ex) {
                throw new FoundationException("Failed to open/close document config stream: " + ex.getMessage());
            }
            if (!errors.isEmpty()) {
                throw new FoundationException("Failed to parse document config: " + (String)errors.get(0));
            }
            return true;
        }
        return false;
    }

    private static String outputPublishActions(@Nullable DocumentConfigHandler handler, @Nullable String project, DocumentConfigHandler customHandler, @Nullable String customProject, DocumentConfigHandler defaultHandler, String actiontypes, String sourcetypes, @Nullable String extension, @Nullable String doctype, Role role) throws FoundationException {
        List<String> actionTypes;
        List<String> list = actionTypes = Strings.isEmpty((String)actiontypes) ? null : Arrays.asList(actiontypes.split(","));
        if (extension != null) {
            extension = extension.toLowerCase();
        }
        boolean hasValidAction = false;
        XMLStringWriter xml = new XMLStringWriter(XML.NamespaceAware.No);
        if (handler != null) {
            xml.openElement("publishing");
            if (handler.overridePublishing()) {
                xml.attribute("override", "true");
                hasValidAction = true;
            }
            xml.attribute("project", project);
            for (DocumentConfigHandler.PublishAction action : handler.getPublishActions()) {
                if (actionTypes != null && !actionTypes.contains(action.getType())) continue;
                for (String sourcetype : sourcetypes.split(",")) {
                    if (!action.matchesSource(sourcetype, extension, doctype)) continue;
                    try {
                        action.toXML((XMLWriter)xml, role);
                        hasValidAction = true;
                    }
                    catch (IOException ex) {
                        throw new FoundationException("Failed to write output: " + ex.getMessage(), ex);
                    }
                }
            }
            xml.closeElement();
        }
        boolean hasValidCustomAction = false;
        XMLStringWriter customXml = new XMLStringWriter(XML.NamespaceAware.No);
        if (!handler.overridePublishing()) {
            customXml.openElement("publishing");
            if (customHandler.overridePublishing()) {
                xml.attribute("override", "true");
                hasValidCustomAction = true;
            }
            customXml.attribute("project", customProject);
            for (DocumentConfigHandler.PublishAction action : customHandler.getPublishActions()) {
                if (actionTypes != null && !actionTypes.contains(action.getType())) continue;
                for (String sourcetype : sourcetypes.split(",")) {
                    if (!action.matchesSource(sourcetype, extension, doctype)) continue;
                    try {
                        action.toXML((XMLWriter)customXml, role);
                        hasValidCustomAction = true;
                    }
                    catch (IOException ex) {
                        throw new FoundationException("Failed to write output: " + ex.getMessage(), ex);
                    }
                }
            }
            customXml.closeElement();
        }
        boolean hasValidDefaultAction = false;
        XMLStringWriter defaultXml = new XMLStringWriter(XML.NamespaceAware.No);
        if (!handler.overridePublishing() && !customHandler.overridePublishing()) {
            defaultXml.openElement("publishing");
            if (defaultHandler.overridePublishing()) {
                xml.attribute("override", "true");
                hasValidDefaultAction = true;
            }
            defaultXml.attribute("project", "default");
            for (DocumentConfigHandler.PublishAction action : defaultHandler.getPublishActions()) {
                if (actionTypes != null && !actionTypes.contains(action.getType())) continue;
                for (String sourcetype : sourcetypes.split(",")) {
                    if (!action.matchesSource(sourcetype, extension, doctype)) continue;
                    try {
                        action.toXML((XMLWriter)defaultXml, role);
                        hasValidDefaultAction = true;
                    }
                    catch (IOException ex) {
                        throw new FoundationException("Failed to write output: " + ex.getMessage(), ex);
                    }
                }
            }
            defaultXml.closeElement();
        }
        return (hasValidAction ? xml.toString() : "") + (hasValidCustomAction ? customXml.toString() : "") + (hasValidDefaultAction ? defaultXml.toString() : "");
    }

    private static class TypeCollector
    implements FileFilter {
        private final Set<String> _types;

        public TypeCollector(Set<String> types) {
            this._types = types;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory() && !file.getName().startsWith(".")) {
                this._types.add(file.getName());
                return true;
            }
            return false;
        }
    }
}

