/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.document;

import com.pageseeder.base.diff.TrackedContent;
import com.pageseeder.base.document.PSMLContentBuilder;
import com.pageseeder.base.document.PSMLContentResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.diffx.token.AttributeToken;
import org.pageseeder.diffx.token.impl.XMLAttribute;
import org.pageseeder.xmlwriter.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(FragmentTracker.class);
    private final Database db;
    private final String fragment;
    private final URI uri;
    private final Group group;
    private @Nullable Member originalAuthor = null;
    private boolean originalAuthorLoaded = false;
    private @Nullable Edit firstEdit = null;

    public FragmentTracker(URI u, String frag, Group g, Database db) {
        this.uri = u;
        this.group = g;
        this.fragment = frag;
        this.db = db;
    }

    public List<Edit> loadEdits(long startEditId, long endEditId) throws QueryFailedException {
        List xlinkids = DatabaseQuery.getXLinkIDsByURIGroupEditsFragment((Database)this.db, (URI)this.uri, (Group)this.group, (String)this.fragment);
        return this.loadEdits(xlinkids, startEditId, endEditId);
    }

    public List<Edit> loadEdits(List<Long> xlinkids, long startEditId, long endEditId) throws QueryFailedException {
        if (xlinkids.isEmpty() && startEditId <= 0L) {
            return this.getOriginalEdit();
        }
        List<Long> alleditids = this.filterRange(xlinkids, startEditId, endEditId);
        if (alleditids.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Edit> byAuthor = new LinkedList<Edit>();
        XLink next = null;
        for (int i = alleditids.size() - 1; i >= 0; --i) {
            Long xlinkid = alleditids.get(i);
            XLink xlink = DatabaseQuery.getXLinkById((Database)this.db, (Long)xlinkid);
            if (xlink == null) {
                LOGGER.error("Failed to load edit XLink with ID {}", (Object)xlinkid);
                continue;
            }
            boolean skipit = "Documentation-Draft".equals(xlink.getStatus());
            if (next == null) {
                if (skipit) continue;
                byAuthor.addFirst(new Edit(xlink, this.fragment, this.xlinkAuthor(xlink), this.db));
                next = xlink;
                continue;
            }
            if (!skipit && !this.isSameAuthor(xlink, next)) {
                byAuthor.addFirst(new Edit(xlink, this.fragment, this.xlinkAuthor(xlink), this.db));
                next = xlink;
                continue;
            }
            ++byAuthor.getFirst().skipped;
        }
        return byAuthor;
    }

    public @Nullable Edit getFirstEdit() {
        return this.firstEdit;
    }

    private List<Long> filterRange(List<Long> xlinkids, long startEditId, long endEditId) {
        if (xlinkids.isEmpty()) {
            return xlinkids;
        }
        int startIndex = -1;
        int endIndex = endEditId > 0L ? 0 : xlinkids.size() - 1;
        for (int i = 0; i < xlinkids.size(); ++i) {
            long xlinkid = xlinkids.get(i);
            if (startEditId > 0L && xlinkid > startEditId && startIndex == -1) {
                startIndex = i;
            }
            if (endEditId > 0L && xlinkid <= endEditId) {
                endIndex = i;
                continue;
            }
            if (endEditId > 0L) break;
        }
        Long xlid = null;
        try {
            if (startIndex == 0 || startEditId <= 0L) {
                xlid = xlinkids.get(0);
                XLink xl = DatabaseQuery.getXLinkById((Database)this.db, (Long)xlid);
                if ("Documentation-Original".equals(xl.getContentRole())) {
                    this.firstEdit = new Edit(xl, this.fragment, xl.getMember(), null);
                    ++startIndex;
                } else {
                    this.firstEdit = new Edit("<fragment/>", this.fragment, this.getOriginalAuthor(), this.uri.getDateCreated());
                }
            }
            if (startIndex > endIndex) {
                return Collections.emptyList();
            }
            if (startIndex > 0) {
                xlid = xlinkids.get(startIndex - 1);
                XLink xl = DatabaseQuery.getXLinkById((Database)this.db, (Long)xlid);
                this.firstEdit = new Edit(xl, this.fragment, xl.getMember(), null);
            } else {
                if (startIndex == -1 && startEditId > 0L) {
                    xlid = xlinkids.get(endIndex);
                    XLink xl = DatabaseQuery.getXLinkById((Database)this.db, (Long)xlid);
                    this.firstEdit = new Edit(xl, this.fragment, xl.getMember(), null);
                    return Collections.emptyList();
                }
                if (startIndex == -1) {
                    startIndex = 0;
                }
            }
        }
        catch (QueryFailedException ex) {
            LOGGER.error("Failed to load first edit with ID {}", (Object)xlid, (Object)ex);
        }
        return xlinkids.subList(startIndex, endIndex + 1);
    }

    private boolean isSameAuthor(XLink a, XLink b) throws QueryFailedException {
        Member authorA = this.xlinkAuthor(a);
        Member authorB = this.xlinkAuthor(b);
        return authorA != null && authorB != null && authorA.getId().equals(authorB.getId());
    }

    private @Nullable Member xlinkAuthor(@Nullable XLink xlink) throws QueryFailedException {
        return xlink == null ? null : ("Documentation-Original".equals(xlink.getContentRole()) && xlink.getMember() == null ? this.getOriginalAuthor() : xlink.getMember());
    }

    private @Nullable Member getOriginalAuthor() throws QueryFailedException {
        if (!this.originalAuthorLoaded) {
            this.originalAuthor = URIRule.getOriginalAuthor(this.uri, this.db);
            this.originalAuthorLoaded = true;
        }
        return this.originalAuthor;
    }

    private List<Edit> getOriginalEdit() throws QueryFailedException {
        String content = "";
        PSMLContentResolver resolver = new PSMLContentResolver(this.db, this.uri, this.group.getName());
        resolver.setFragment(this.fragment, null, false, false);
        resolver.setReleaseId(0L);
        try (InputStream in = resolver.getContent();){
            content = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        }
        catch (URIException | IOException ex) {
            LOGGER.error("Failed to read fragment content from  PSML content resolver", (Throwable)ex);
        }
        return Collections.singletonList(new Edit(content, this.fragment, this.getOriginalAuthor(), this.uri.getDateCreated()));
    }

    public static TrackedContent<Edit> toTrackedContent(Edit edit) {
        return new TrackedContent<Edit>(edit.getContent(), edit);
    }

    public static List<AttributeToken> toOriginAttributes(Edit edit) {
        return Collections.singletonList(new XMLAttribute("editid", edit.getEditID().toString()));
    }

    public static String toOriginReference(Edit edit) {
        return edit.getEditID().toString();
    }

    public static class Edit
    implements UniversallyPrintable {
        private final @Nullable XLink xlink;
        private final @Nullable String content;
        private final @Nullable Date createdDate;
        private final @Nullable Member author;
        private final List<XLink> notes;
        private final String fragment;
        private int skipped = 0;

        Edit(XLink xl, String fragment, @Nullable Member author, @Nullable Database db) throws QueryFailedException {
            this.xlink = xl;
            this.fragment = fragment;
            this.notes = db != null ? DatabaseQuery.getRepliesByContentRole((Database)db, (XLink)xl, (String[])new String[]{"Documentation-Note"}, null) : Collections.emptyList();
            this.author = author;
            this.content = null;
            this.createdDate = null;
        }

        Edit(String content, String fragment, @Nullable Member author, Date created) {
            this.xlink = null;
            this.fragment = fragment;
            this.notes = Collections.emptyList();
            this.author = author;
            this.content = content;
            this.createdDate = created;
        }

        String getContent() {
            Content xlContent;
            Content content = xlContent = this.xlink == null || "Documentation-Hidden".equals(this.xlink.getContentRole()) ? null : (Content)this.xlink.getContentsCol().stream().findFirst().orElse(null);
            if (xlContent != null) {
                if (!"application/vnd.pageseeder.psml+xml".equals(xlContent.getType())) {
                    return this.wrapWithMediaFragment(xlContent.getData(), this.fragment, xlContent.getType());
                }
                return xlContent.getData();
            }
            return Strings.isEmpty((String)this.content) ? "<fragment/>" : this.content;
        }

        Long getEditID() {
            return this.xlink != null ? this.xlink.getId() : 0L;
        }

        XLink getEdit() {
            return this.xlink;
        }

        private String wrapWithMediaFragment(String data, String fragment, @Nullable String mediatype) {
            if (mediatype == null) {
                return data;
            }
            return "<media-fragment id='" + XML.escapeAttr((String)fragment) + "' mediatype='" + XML.escapeAttr((String)mediatype) + "'>" + (mediatype.endsWith("xml") ? data : XML.escape((String)data)) + "</media-fragment>";
        }

        @Override
        public void print(OutputPrinter out) {
            Date created;
            boolean isDraft = this.xlink != null && "Documentation-Draft".equals(this.xlink.getStatus());
            boolean isOriginal = this.xlink != null && "Documentation-Original".equals(this.xlink.getContentRole());
            boolean isDeleted = this.xlink != null && "Documentation-Hidden".equals(this.xlink.getContentRole());
            out.startObject(isDraft ? "draft" : "edit");
            out.field("id", this.getEditID().toString());
            Date date = created = this.xlink != null ? this.xlink.getDate() : this.createdDate;
            if (created != null) {
                out.field("created", ISO8601.format((long)created.getTime(), (ISO8601)ISO8601.DATETIME));
            }
            if (isDeleted) {
                out.field("deleted", true);
            }
            if (isOriginal) {
                out.field("original", true);
            }
            if (this.skipped > 0) {
                out.field("skipped", this.skipped);
            }
            if (this.author != null) {
                this.printAuthor(this.author, "author", out);
            } else if (this.xlink != null && this.xlink.getAuthorName() != null) {
                out.startObject("author");
                out.field("fullname", this.xlink.getAuthorName(), OutputPrinter.FieldOption.XML_ELEMENT);
                out.endObject();
            }
            if (this.xlink != null && this.xlink.getModifiedBy() != null) {
                this.printAuthor(this.xlink.getModifiedBy(), "draftauthor", out);
            }
            if (!this.notes.isEmpty()) {
                out.startCollection("notes");
                for (XLink note : this.notes) {
                    PSMLContentBuilder.note(note, out);
                }
                out.endCollection();
            }
            out.endObject();
        }

        private void printAuthor(Member member, String name, OutputPrinter out) {
            out.startObject(name);
            out.field("id", member.getId());
            if (member.getFirstName() != null) {
                out.field("firstname", member.getFirstName());
            }
            if (member.getSurname() != null) {
                out.field("surname", member.getSurname());
            }
            if (member.getUsername() != null) {
                out.field("username", member.getUsername());
            }
            if (member.getExternalUserId() != null) {
                out.field("externalid", member.getExternalUserId());
            }
            out.field("fullname", MemberRule.getFullName(member), OutputPrinter.FieldOption.XML_ELEMENT);
            out.endObject();
        }
    }
}

