/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.diff;

import com.pageseeder.base.diff.TrackedToken;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.diffx.token.TextToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.XMLTokenType;
import org.pageseeder.diffx.token.impl.CharactersToken;

public final class TrackedTokens {
    private TrackedTokens() {
    }

    public static <T> List<TrackedToken<T>> track(List<XMLToken> tokens, @Nullable T origin) {
        return tokens.stream().map(token -> new TrackedToken<Object>((XMLToken)token, origin)).collect(Collectors.toList());
    }

    public static <T> List<TrackedToken<T>> coalesce(List<TrackedToken<T>> tokens) {
        ArrayList<TrackedToken<T>> coalesced = new ArrayList<TrackedToken<T>>();
        ArrayList<TrackedToken<T>> buffer = new ArrayList<TrackedToken<T>>();
        for (TrackedToken<T> token : tokens) {
            if (!(buffer.isEmpty() || token.getType() == XMLTokenType.TEXT && token.getOrigin() == ((TrackedToken)buffer.get(0)).getOrigin())) {
                coalesced.add(TrackedTokens.coalesceText(buffer));
                buffer.clear();
            }
            if (token.getType() == XMLTokenType.TEXT) {
                buffer.add(token);
                continue;
            }
            coalesced.add(token);
        }
        if (!buffer.isEmpty()) {
            coalesced.add(TrackedTokens.coalesceText(buffer));
        }
        return coalesced;
    }

    private static <T> TrackedToken<T> coalesceText(List<TrackedToken<T>> tokens) {
        if (tokens.size() == 1) {
            return tokens.get(0);
        }
        StringBuilder text = new StringBuilder();
        for (TrackedToken<T> token : tokens) {
            text.append(((TextToken)token.getToken()).getCharacters());
        }
        return new TrackedToken<T>((XMLToken)new CharactersToken((CharSequence)text.toString()), tokens.get(0).getOrigin());
    }
}

